/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.JavaPlatform;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.Platform;
import net.sf.saxon.SourceResolver;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ExtensionFunctionFactory;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.StandardCollectionURIResolver;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.instruct.Debugger;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentNumberAllocator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.StandardModuleURIResolver;
import net.sf.saxon.sort.CollationURIResolver;
import net.sf.saxon.sort.StandardCollationURIResolver;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaURIResolver;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Configuration
implements Serializable,
SourceResolver {
    private Platform platform = JavaPlatform.getInstance();
    private transient URIResolver uriResolver;
    private StandardURIResolver systemURIResolver = new StandardURIResolver(this);
    protected transient ErrorListener listener;
    private int xmlVersion = 10;
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private TraceListener traceListener = null;
    private FunctionLibrary extensionBinder;
    private CollationURIResolver collationResolver = StandardCollationURIResolver.getInstance();
    private CollectionURIResolver collectionResolver = new StandardCollectionURIResolver();
    private ModuleURIResolver moduleURIResolver = null;
    private ModuleURIResolver standardModuleURIResolver = new StandardModuleURIResolver(this);
    private SchemaURIResolver schemaURIResolver = null;
    private SourceResolver sourceResolver = this;
    protected VendorFunctionLibrary vendorFunctionLibrary;
    protected int recoveryPolicy = 1;
    private String messageEmitterClass = "net.sf.saxon.event.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private transient OutputURIResolver outputURIResolver;
    private boolean timing = false;
    private boolean versionWarning = true;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean validation = false;
    private boolean allNodesUntyped = false;
    private boolean lazyConstructionMode = false;
    private boolean allowMultiThreading = false;
    private int stripsWhiteSpace = 11;
    private NamePool targetNamePool = null;
    private DocumentNumberAllocator documentNumberAllocator = new DocumentNumberAllocator();
    private XPathContext conversionContext = null;
    private transient TypeHierarchy typeHierarchy;
    private int hostLanguage = 50;
    private int schemaValidationMode = 3;
    private boolean validationWarnings = false;
    private boolean retainDTDattributeTypes = false;
    private Debugger debugger = null;
    protected Optimizer optimizer = null;
    private ExtensionFunctionFactory extensionFunctionFactory = new ExtensionFunctionFactory(this);
    private transient ClassLoader classLoader;
    private int implicitTimezone;
    private transient List sourceParserPool = new ArrayList(5);
    private transient List styleParserPool = new ArrayList(5);
    private static List sharedExternalObjectModels = null;
    private List externalObjectModels = null;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSLT = 50;
    public static final int XQUERY = 51;
    public static final int XML_SCHEMA = 52;
    public static final int JAVA_APPLICATION = 53;
    public static final int XPATH = 54;

    public Configuration() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Class clazz = Configuration.class;
        synchronized (clazz) {
            if (sharedExternalObjectModels == null) {
                this.registerStandardObjectModels();
            }
            this.externalObjectModels = new ArrayList(sharedExternalObjectModels);
        }
        this.targetNamePool = NamePool.getDefaultNamePool();
        this.extensionBinder = new JavaExtensionLibrary(this);
        GregorianCalendar calendar = new GregorianCalendar();
        int tzmsecs = calendar.get(15) + calendar.get(16);
        this.implicitTimezone = tzmsecs / 60000;
    }

    public static Configuration makeSchemaAwareConfiguration(ClassLoader classLoader) throws RuntimeException {
        try {
            Class<?> theClass;
            ClassLoader loader = classLoader;
            if (loader == null) {
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception err) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (loader != null) {
                try {
                    theClass = loader.loadClass("com.saxonica.validate.SchemaAwareConfiguration");
                }
                catch (Exception ex) {
                    theClass = Class.forName("com.saxonica.validate.SchemaAwareConfiguration");
                }
            } else {
                theClass = Class.forName("com.saxonica.validate.SchemaAwareConfiguration");
            }
            Configuration config = (Configuration)theClass.newInstance();
            config.init();
            return config;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getProductTitle() {
        return "Saxon " + Version.getProductVersion() + this.platform.getPlatformSuffix() + " from Saxonica";
    }

    public boolean isSchemaAware(int language) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int hostLanguage) {
        this.hostLanguage = hostLanguage;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public URIResolver getURIResolver() {
        if (this.uriResolver == null) {
            return this.systemURIResolver;
        }
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public StandardURIResolver getSystemURIResolver() {
        return this.systemURIResolver;
    }

    public URIResolver makeURIResolver(String className) throws TransformerException {
        Object obj = this.getInstance(className, null);
        if (obj instanceof URIResolver) {
            return (URIResolver)obj;
        }
        throw new DynamicError("Class " + className + " is not a URIResolver");
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
            ((StandardErrorListener)this.listener).setRecoveryPolicy(this.recoveryPolicy);
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener listener) {
        this.listener = listener;
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            err.setHasBeenReported();
        }
    }

    public void setMultiThreading(boolean multithreading) {
        this.allowMultiThreading = multithreading;
    }

    public boolean isMultiThreading() {
        return this.allowMultiThreading;
    }

    public void setXMLVersion(int version) {
        this.xmlVersion = version;
    }

    public int getXMLVersion() {
        return this.xmlVersion;
    }

    public NameChecker getNameChecker() {
        return this.xmlVersion == 10 ? Name10Checker.getInstance() : Name11Checker.getInstance();
    }

    public XPathContext getConversionContext() {
        if (this.conversionContext == null) {
            this.conversionContext = new IndependentContext(this).makeEarlyEvaluationContext();
        }
        return this.conversionContext;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(int treeModel) {
        this.treeModel = treeModel;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.lineNumbering = lineNumbering;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
        this.setMultiThreading(false);
    }

    public TraceListener makeTraceListener(String className) throws XPathException {
        Object obj = this.getInstance(className, null);
        if (obj instanceof TraceListener) {
            return (TraceListener)obj;
        }
        throw new DynamicError("Class " + className + " is not a TraceListener");
    }

    public void setExtensionBinder(FunctionLibrary binder) {
        this.extensionBinder = binder;
    }

    public FunctionLibrary getExtensionBinder() {
        return this.extensionBinder;
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public void setCollationURIResolver(CollationURIResolver resolver) {
        this.collationResolver = resolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.collationResolver;
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver) {
        this.collectionResolver = resolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public void setModuleURIResolver(String className) throws TransformerException {
        Object obj = this.getInstance(className, null);
        if (!(obj instanceof ModuleURIResolver)) {
            throw new DynamicError("Class " + className + " is not a LocationHintResolver");
        }
        this.setModuleURIResolver((ModuleURIResolver)obj);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.standardModuleURIResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setRecoveryPolicy(int recoveryPolicy) {
        this.recoveryPolicy = recoveryPolicy;
    }

    public String getMessageEmitterClass() {
        return this.messageEmitterClass;
    }

    public void setMessageEmitterClass(String messageEmitterClass) {
        this.messageEmitterClass = messageEmitterClass;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String sourceParserClass) {
        this.sourceParserClass = sourceParserClass;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String styleParserClass) {
        this.styleParserClass = styleParserClass;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.outputURIResolver == null) {
            this.outputURIResolver = StandardOutputResolver.getInstance();
        }
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    public boolean isVersionWarning() {
        return this.versionWarning;
    }

    public void setVersionWarning(boolean warn) {
        this.versionWarning = warn;
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean allowExternalFunctions) {
        this.allowExternalFunctions = allowExternalFunctions;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setRetainDTDAttributeTypes(boolean useTypes) throws TransformerFactoryConfigurationError {
        if (useTypes && !this.isSchemaAware(52)) {
            throw new TransformerFactoryConfigurationError("Retaining DTD attribute types requires the schema-aware product");
        }
        this.retainDTDattributeTypes = useTypes;
    }

    public boolean isRetainDTDAttributeTypes() {
        return this.retainDTDattributeTypes;
    }

    public void setTraceExternalFunctions(boolean traceExternalFunctions) {
        this.traceExternalFunctions = traceExternalFunctions;
    }

    public ExtensionFunctionFactory getExtensionFunctionFactory() {
        return this.extensionFunctionFactory;
    }

    public void setExtensionFunctionFactory(ExtensionFunctionFactory factory) {
        this.extensionFunctionFactory = factory;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public void setAllNodesUntyped(boolean allUntyped) {
        this.allNodesUntyped = allUntyped;
    }

    public boolean areAllNodesUntyped() {
        return this.allNodesUntyped;
    }

    public int getSchemaValidationMode() {
        return this.schemaValidationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        switch (validationMode) {
            case 3: 
            case 4: {
                break;
            }
            case 1: 
            case 2: {
                if (this.isSchemaAware(52)) break;
                this.needSchemaAwareVersion();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation mode " + validationMode);
            }
        }
        this.schemaValidationMode = validationMode;
    }

    public void setValidationWarnings(boolean warn) {
        this.validationWarnings = warn;
    }

    public boolean isValidationWarnings() {
        return this.validationWarnings;
    }

    public NamePool getNamePool() {
        return this.targetNamePool;
    }

    public void setNamePool(NamePool targetNamePool) {
        this.targetNamePool = targetNamePool;
    }

    public final TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.documentNumberAllocator;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsWhiteSpace == 12;
    }

    public void setStripsAllWhiteSpace(boolean stripsAllWhiteSpace) {
        if (stripsAllWhiteSpace) {
            this.stripsWhiteSpace = 12;
        }
    }

    public void setStripsWhiteSpace(int kind) {
        this.stripsWhiteSpace = kind;
    }

    public int getStripsWhiteSpace() {
        return this.stripsWhiteSpace;
    }

    public synchronized XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList(10);
        }
        if (this.sourceParserPool.size() > 0) {
            int n = this.sourceParserPool.size() - 1;
            XMLReader parser = (XMLReader)this.sourceParserPool.get(n);
            this.sourceParserPool.remove(n);
            return parser;
        }
        XMLReader parser = this.getSourceParserClass() != null ? this.makeParser(this.getSourceParserClass()) : this.loadParser();
        try {
            Sender.configureParser(parser);
        }
        catch (DynamicError err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (this.isValidation()) {
            try {
                parser.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException err) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return parser;
    }

    public synchronized void reuseSourceParser(XMLReader parser) {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList(10);
        }
        this.sourceParserPool.add(parser);
    }

    private XMLReader loadParser() {
        XMLReader parser;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        catch (SAXException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        return parser;
    }

    public synchronized XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList(10);
        }
        if (this.styleParserPool.size() > 0) {
            int n = this.styleParserPool.size() - 1;
            XMLReader parser = (XMLReader)this.styleParserPool.get(n);
            this.styleParserPool.remove(n);
            return parser;
        }
        XMLReader parser = this.getStyleParserClass() != null ? this.makeParser(this.getStyleParserClass()) : this.loadParser();
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        catch (SAXNotSupportedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        return parser;
    }

    public synchronized void reuseStyleParser(XMLReader parser) {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList(10);
        }
        this.styleParserPool.add(parser);
    }

    public String readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, String expected) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, List schemaLocations, String expected) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public String readInlineSchema(NodeInfo root, String expected, ErrorListener errorListener) throws SchemaException {
        this.needSchemaAwareVersion();
        return null;
    }

    private void needSchemaAwareVersion() {
        throw new UnsupportedOperationException("You need the schema-aware version of Saxon for this operation");
    }

    public void addSchemaSource(Source schemaSource) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public void addSchemaSource(Source schemaSource, ErrorListener errorListener) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public void addSchema(Object schema) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
    }

    public Object getSchema(String namespace) {
        return null;
    }

    public Set getImportedNamespaces() {
        return Collections.EMPTY_SET;
    }

    public void sealNamespace(String namespace) {
    }

    public boolean isSealedNamespace(String namespace) {
        return false;
    }

    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return null;
    }

    public SchemaType getSchemaType(int fingerprint) {
        if (fingerprint < 1023) {
            return BuiltInSchemaFactory.getSchemaType(fingerprint);
        }
        return null;
    }

    public Receiver getDocumentValidator(Receiver receiver, String systemId, NamePool namePool, int validationMode, int stripSpace, SchemaType schemaType) {
        return receiver;
    }

    public Receiver getElementValidator(Receiver receiver, int nameCode, int locationId, SchemaType schemaType, int validation, NamePool pool) throws XPathException {
        return receiver;
    }

    public int validateAttribute(int nameCode, CharSequence value, int validation) throws ValidationException {
        return -1;
    }

    public Receiver getAnnotationStripper(Receiver destination) {
        return destination;
    }

    public NodeTest makeSubstitutionGroupTest(SchemaDeclaration elementDecl) {
        this.needSchemaAwareVersion();
        return null;
    }

    public XMLReader makeParser(String className) throws TransformerFactoryConfigurationError {
        Object obj;
        try {
            obj = this.getInstance(className, null);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (obj instanceof XMLReader) {
            return (XMLReader)obj;
        }
        throw new TransformerFactoryConfigurationError("Class " + className + " is not a SAX2 XMLReader");
    }

    public static Locale getLocale(String lang) {
        String country;
        String language;
        int hyphen = lang.indexOf("-");
        if (hyphen < 1) {
            language = lang;
            country = "";
        } else {
            language = lang.substring(1, hyphen);
            country = lang.substring(hyphen + 1);
        }
        return new Locale(language, country);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Optimizer getOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
        }
        return this.optimizer;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getClass(String className, boolean tracing, ClassLoader classLoader) throws XPathException {
        if (tracing) {
            System.err.println("Loading " + className);
        }
        try {
            ClassLoader loader = classLoader;
            if (loader == null) {
                loader = this.classLoader;
            }
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (loader != null) {
                try {
                    return loader.loadClass(className);
                }
                catch (Exception ex) {
                    return Class.forName(className);
                }
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            if (tracing) {
                System.err.println("No Java class " + className + " could be loaded");
            }
            throw new DynamicError("Failed to load " + className, e);
        }
    }

    public Object getInstance(String className, ClassLoader classLoader) throws XPathException {
        Class theclass = this.getClass(className, false, classLoader);
        try {
            return theclass.newInstance();
        }
        catch (Exception err) {
            throw new DynamicError("Failed to instantiate class " + className, err);
        }
    }

    public Comparator makeCollator(String className) throws XPathException {
        Object handler = this.getInstance(className, null);
        if (handler instanceof Comparator) {
            return (Comparator)handler;
        }
        throw new DynamicError("Failed to load collation class " + className + ": it is not an instance of java.util.Comparator");
    }

    public void setLazyConstructionMode(boolean lazy) {
        this.lazyConstructionMode = lazy;
    }

    public boolean isLazyConstructionMode() {
        return this.lazyConstructionMode;
    }

    private void registerStandardObjectModels() {
        String[] models = new String[]{"net.sf.saxon.dom.DOMEnvelope", "net.sf.saxon.dom.DOMObjectModel", "net.sf.saxon.jdom.JDOMObjectModel", "net.sf.saxon.xom.XOMObjectModel", "net.sf.saxon.dom4j.DOM4JObjectModel"};
        String[] nodes = new String[]{"net.sf.saxon.dom.NodeOverNodeInfo", "org.w3c.dom.Node", "org.jdom.Element", "nu.xom.Node", "org.dom4j.Element"};
        sharedExternalObjectModels = new ArrayList(4);
        for (int i = 0; i < models.length; ++i) {
            try {
                this.getClass(nodes[i], false, null);
                ExternalObjectModel model = (ExternalObjectModel)this.getInstance(models[i], null);
                sharedExternalObjectModels.add(model);
                continue;
            }
            catch (XPathException err) {
                continue;
            }
            catch (ClassCastException err) {
                System.err.println("Warning: external object model " + models[i] + " has been loaded, but is not an instance of net.sf.saxon.om.ExternalObjectModel");
                continue;
            }
            catch (Throwable err) {
                System.err.println("Warning: failed to load external object model: " + err.getMessage());
            }
        }
    }

    public void registerExternalObjectModel(ExternalObjectModel model) {
        if (this.externalObjectModels == null) {
            this.externalObjectModels = new ArrayList(5);
        }
        if (!this.externalObjectModels.contains(model)) {
            this.externalObjectModels.add(model);
        }
    }

    public ExternalObjectModel findExternalObjectModel(Object node) {
        if (this.externalObjectModels == null) {
            return null;
        }
        Iterator it = this.externalObjectModels.iterator();
        while (it.hasNext()) {
            ExternalObjectModel model = (ExternalObjectModel)it.next();
            if (!model.isRecognizedNode(node)) continue;
            return model;
        }
        return null;
    }

    public List getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration();
        pipe.setConfiguration(this);
        pipe.setErrorListener(this.getErrorListener());
        pipe.setURIResolver(this.getURIResolver());
        pipe.setSchemaURIResolver(this.getSchemaURIResolver());
        return pipe;
    }

    public void setImplicitTimezone(int minutes) {
        if (minutes < -840 || minutes > 840) {
            throw new IllegalArgumentException("Implicit timezone is out of range: range is -840 to +840 minutes");
        }
        this.implicitTimezone = minutes;
    }

    public int getImplicitTimezone() {
        return this.implicitTimezone;
    }

    public static Configuration getConfiguration(XPathContext context) {
        return context.getConfiguration();
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.sourceResolver = resolver;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public Source resolveSource(Source source, Configuration config) throws XPathException {
        if (source instanceof AugmentedSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return source;
        }
        if (source instanceof SAXSource) {
            return source;
        }
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof NodeInfo) {
            return source;
        }
        if (source instanceof PullProvider) {
            return source;
        }
        return null;
    }

    public Receiver getOutputMethod(String clarkName) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigurationProperty(String name, Object value) {
        Configuration config = this;
        if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            config.setTreeModel((Integer)value);
        } else if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("ALLOW_EXTERNAL_FUNCTIONS must be a boolean");
            }
            config.setAllowExternalFunctions((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("RECOGNIZE_QUERY_URI_PARAMETERS must be a boolean");
            }
            config.getSystemURIResolver().setRecognizeQueryParameters((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("TRACE_EXTERNAL_FUNCTIONS must be a boolean");
            }
            config.setTraceExternalFunctions((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/timing")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("TIMING must be a boolean");
            }
            config.setTiming((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/validation")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("DTD_VALIDATION must be a boolean");
            }
            config.setValidation((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            void var4_4;
            int ival;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("STRIP_WHITESPACE must be a string");
            }
            if (value.equals("all")) {
                ival = 12;
            } else if (value.equals("none")) {
                ival = 10;
            } else if (value.equals("ignorable")) {
                ival = 11;
            } else {
                throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + value + "': must be 'all', 'none', or 'ignorable'");
            }
            config.setStripsWhiteSpace((int)var4_4);
        } else if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION must be an integer");
            }
            config.setSchemaValidationMode((Integer)value);
        } else if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("VALIDATION_WARNINGS must be a boolean");
            }
            config.setValidationWarnings((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("VERSION_WARNING must be a boolean");
            }
            config.setVersionWarning((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            if (!(value instanceof TraceListener)) {
                throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
            }
            config.setTraceListener((TraceListener)value);
        } else if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("LINE_NUMBERING value must be Boolean");
            }
            config.setLineNumbering((Boolean)value);
        } else if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("RECOVERY_POLICY value must be Integer");
            }
            config.setRecoveryPolicy((Integer)value);
        } else if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("MESSAGE_EMITTER class must be a String");
            }
            config.setMessageEmitterClass((String)value);
        } else if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SOURCE_PARSER class must be a String");
            }
            config.setSourceParserClass((String)value);
        } else if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("STYLE_PARSER class must be a String");
            }
            config.setStyleParserClass((String)value);
        } else if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            if (!(value instanceof OutputURIResolver)) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net.sf.saxon.OutputURIResolver");
            }
            config.setOutputURIResolver((OutputURIResolver)value);
        } else if (name.equals("http://saxon.sf.net/feature/namePool")) {
            if (!(value instanceof NamePool)) {
                throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
            }
            config.setNamePool((NamePool)value);
        } else if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            if (!(value instanceof CollationURIResolver)) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net.sf.saxon.sort.CollationURIResolver");
            }
            config.setCollationURIResolver((CollationURIResolver)value);
        } else if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            if (!(value instanceof CollectionURIResolver)) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER value must be an instance of net.sf.saxon.CollectionURIResolver");
            }
            config.setCollectionURIResolver((CollectionURIResolver)value);
        } else if (name.equals("http://saxon.sf.bet/feature/xml-version")) {
            if (!(value instanceof String) || !value.equals("1.0") && !value.equals("1.1")) {
                throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            config.setXMLVersion(value.equals("1.0") ? 10 : 11);
        } else {
            throw new IllegalArgumentException("Unknown attribute " + name);
        }
    }

    public Object getConfigurationProperty(String name) {
        Configuration config = this;
        if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            return new Integer(config.getTreeModel());
        }
        if (name.equals("http://saxon.sf.net/feature/timing")) {
            return config.isTiming();
        }
        if (name.equals("http://saxon.sf.net/feature/validation")) {
            return config.isValidation();
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            return new Integer(config.getSchemaValidationMode());
        }
        if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            return config.isValidationWarnings();
        }
        if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            return config.isAllowExternalFunctions();
        }
        if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            return config.getSystemURIResolver().queryParametersAreRecognized();
        }
        if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            return config.isTraceExternalFunctions();
        }
        if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            return config.isVersionWarning();
        }
        if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            return config.getTraceListener();
        }
        if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            return config.isLineNumbering();
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            return new Integer(config.getRecoveryPolicy());
        }
        if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            return config.getMessageEmitterClass();
        }
        if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            return config.getSourceParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            return config.getStyleParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            return config.getOutputURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/namePool")) {
            return config.getNamePool();
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            return config.getCollationURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            return config.getCollectionURIResolver();
        }
        throw new IllegalArgumentException("Unknown attribute " + name);
    }
}

