/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;

public final class FirstItemExpression
extends UnaryExpression {
    public FirstItemExpression(Expression expression) {
        super(expression);
        this.computeStaticProperties();
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        if (!Cardinality.allowsMany(this.operand.getCardinality())) {
            if (this.operand instanceof ComputedExpression) {
                ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
            }
            return this.operand;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.operand = this.doPromotion(this.operand, promotionOffer);
        }
        return this;
    }

    public int computeCardinality() {
        return this.operand.getCardinality() & 0xFFFF7FFF;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.operand.iterate(xPathContext).next();
    }

    public String displayOperator(Configuration configuration) {
        return "first item of";
    }
}

