/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class ValueComparison
extends BinaryExpression
implements ComparisonExpression {
    private AtomicComparer comparer;
    private BooleanValue resultWhenEmpty = null;

    public ValueComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public void setResultWhenEmpty(BooleanValue booleanValue) {
        this.resultWhenEmpty = booleanValue;
    }

    public BooleanValue getResultWhenEmpty() {
        return this.resultWhenEmpty;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertUntypedToOther() {
        return false;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Comparator comparator;
        int n;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        if (this.operand0 instanceof EmptySequence) {
            return this.operand0;
        }
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        if (this.operand1 instanceof EmptySequence) {
            return this.operand1;
        }
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, false, roleLocator2, staticContext);
        AtomicType atomicType = this.operand0.getItemType(typeHierarchy).getAtomizedItemType();
        AtomicType atomicType2 = this.operand1.getItemType(typeHierarchy).getAtomizedItemType();
        int n2 = atomicType.getPrimitiveType();
        if (n2 == 642) {
            n2 = 513;
        }
        if ((n = atomicType2.getPrimitiveType()) == 642) {
            n = 513;
        }
        if (!Type.isComparable(n2, n, Token.isOrderedOperator(this.operator))) {
            boolean bl = Cardinality.allowsZero(this.operand0.getCardinality());
            boolean bl2 = Cardinality.allowsZero(this.operand1.getCardinality());
            if (bl || bl2) {
                String string = null;
                if (bl) {
                    string = "the first operand is";
                }
                if (bl2) {
                    string = "the second operand is";
                }
                if (bl && bl2) {
                    string = "one or both operands are";
                }
                staticContext.issueWarning("Comparison of " + atomicType.toString(staticContext.getNamePool()) + (bl ? "?" : "") + " to " + atomicType2.toString(staticContext.getNamePool()) + (bl2 ? "?" : "") + " will fail unless " + string + " empty", this);
            } else {
                StaticError staticError = new StaticError("Cannot compare " + atomicType.toString(staticContext.getNamePool()) + " to " + atomicType2.toString(staticContext.getNamePool()));
                staticError.setIsTypeError(true);
                staticError.setErrorCode("XPTY0004");
                throw staticError;
            }
        }
        if (this.operator != 44 && this.operator != 45) {
            if (!Type.isOrdered(n2)) {
                StaticError staticError = new StaticError("Type " + atomicType.toString(staticContext.getNamePool()) + " is not an ordered type");
                staticError.setErrorCode("XPTY0004");
                staticError.setIsTypeError(true);
                throw staticError;
            }
            if (!Type.isOrdered(n)) {
                StaticError staticError = new StaticError("Type " + atomicType2.toString(staticContext.getNamePool()) + " is not an ordered type");
                staticError.setErrorCode("XPTY0004");
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
        if ((comparator = staticContext.getCollation(staticContext.getDefaultCollationName())) == null) {
            comparator = CodepointCollator.getInstance();
        }
        this.comparer = new AtomicComparer(comparator, staticContext.getConfiguration());
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        int n2;
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        if (Aggregate.isCountFunction(this.operand0) && this.operand1 instanceof AtomicValue) {
            if (ValueComparison.isZero(this.operand1)) {
                if (this.operator == 44 || this.operator == 49) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("empty", 1, staticContext.getNamePool());
                    Expression[] expressionArray = new Expression[]{((FunctionCall)this.operand0).argument[0]};
                    functionCall.setArguments(expressionArray);
                    functionCall.setParentExpression(this.getParentExpression());
                    return functionCall;
                }
                if (this.operator == 45 || this.operator == 46) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("exists", 1, staticContext.getNamePool());
                    Expression[] expressionArray = new Expression[]{ExpressionTool.unsorted(optimizer, ((FunctionCall)this.operand0).argument[0], false)};
                    functionCall.setArguments(expressionArray);
                    functionCall.setParentExpression(this.getParentExpression());
                    return functionCall;
                }
                if (this.operator == 48) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            if (this.operand1 instanceof IntegerValue && (this.operator == 46 || this.operator == 48)) {
                long l = ((IntegerValue)this.operand1).longValue();
                if (this.operator == 46) {
                    ++l;
                }
                FunctionCall functionCall = SystemFunction.makeSystemFunction("exists", 1, staticContext.getNamePool());
                Expression[] expressionArray = new Expression[1];
                FilterExpression filterExpression = new FilterExpression(((FunctionCall)this.operand0).argument[0], new IntegerValue(l));
                expressionArray[0] = filterExpression;
                functionCall.setArguments(expressionArray);
                functionCall.setParentExpression(this.getParentExpression());
                return functionCall;
            }
        }
        if (Aggregate.isCountFunction(this.operand1) && ValueComparison.isZero(this.operand0)) {
            ValueComparison valueComparison = new ValueComparison(this.operand1, Token.inverse(this.operator), this.operand0);
            valueComparison.setParentExpression(this.getParentExpression());
            return valueComparison.typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
        }
        if (this.operand0 instanceof StringLength && ((StringLength)this.operand0).getNumberOfArguments() == 1 && ValueComparison.isZero(this.operand1)) {
            ((StringLength)this.operand0).setShortcut();
        }
        if (this.operand1 instanceof StringLength && ((StringLength)this.operand1).getNumberOfArguments() == 1 && ValueComparison.isZero(this.operand0)) {
            ((StringLength)this.operand1).setShortcut();
        }
        if (this.operand0 instanceof Position && this.operand1 instanceof Last) {
            switch (this.operator) {
                case 44: 
                case 48: {
                    IsLastExpression isLastExpression = new IsLastExpression(true);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 45: 
                case 47: {
                    IsLastExpression isLastExpression = new IsLastExpression(false);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 46: {
                    return BooleanValue.FALSE;
                }
                case 49: {
                    return BooleanValue.TRUE;
                }
            }
        }
        if (this.operand0 instanceof Last && this.operand1 instanceof Position) {
            switch (this.operator) {
                case 44: 
                case 49: {
                    IsLastExpression isLastExpression = new IsLastExpression(true);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 45: 
                case 46: {
                    IsLastExpression isLastExpression = new IsLastExpression(false);
                    isLastExpression.setParentExpression(this.getParentExpression());
                    isLastExpression.setLocationId(this.getLocationId());
                    return isLastExpression;
                }
                case 47: {
                    return BooleanValue.FALSE;
                }
                case 48: {
                    return BooleanValue.TRUE;
                }
            }
        }
        if (this.operand0 instanceof Position) {
            n2 = this.operand1 instanceof IntegerValue;
            n = 0;
            if (n2 != 0 && (n = (int)((IntegerValue)this.operand1).longValue()) < 0) {
                n = 0;
            }
            switch (this.operator) {
                case 44: {
                    return this.makePositionRange(this.operand1, this.operand1);
                }
                case 48: {
                    return this.makePositionRange(this.operand1, null);
                }
                case 45: {
                    if (n2 == 0 || n != 1) break;
                    return this.makePositionRange(2, Integer.MAX_VALUE);
                }
                case 47: {
                    if (n2 == 0) break;
                    return this.makePositionRange(1, n - 1);
                }
                case 46: {
                    if (n2 == 0) break;
                    return this.makePositionRange(n + 1, Integer.MAX_VALUE);
                }
                case 49: {
                    if (n2 == 0) break;
                    return this.makePositionRange(1, n);
                }
            }
        }
        if (this.operand1 instanceof Position) {
            n2 = 0;
            n = this.operand0 instanceof IntegerValue;
            if (n != 0 && (n2 = (int)((IntegerValue)this.operand0).longValue()) < 0) {
                n2 = 0;
            }
            switch (this.operator) {
                case 44: {
                    return this.makePositionRange(this.operand0, this.operand0);
                }
                case 49: {
                    return this.makePositionRange(this.operand0, null);
                }
                case 45: {
                    if (n == 0 || n2 != 1) break;
                    return this.makePositionRange(2, Integer.MAX_VALUE);
                }
                case 46: {
                    if (n == 0) break;
                    return this.makePositionRange(1, n2 - 1);
                }
                case 47: {
                    if (n == 0) break;
                    return this.makePositionRange(n2 + 1, Integer.MAX_VALUE);
                }
                case 48: {
                    if (n == 0) break;
                    return this.makePositionRange(1, n2);
                }
            }
        }
        if (NamePart.isGenerateIdFunction(this.operand0) && NamePart.isGenerateIdFunction(this.operand1)) {
            FunctionCall functionCall = (FunctionCall)this.operand0;
            FunctionCall functionCall2 = (FunctionCall)this.operand1;
            if (!Cardinality.allowsMany(functionCall.argument[0].getCardinality()) && !Cardinality.allowsMany(functionCall2.argument[0].getCardinality()) && this.operator == 44) {
                IdentityComparison identityComparison = new IdentityComparison(functionCall.argument[0], 20, functionCall2.argument[0]);
                identityComparison.setGenerateIdEmulation(true);
                identityComparison.setLocationId(this.getLocationId());
                identityComparison.setParentExpression(this.getParentExpression());
                return identityComparison.simplify(staticContext).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
            }
        }
        if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
            return (AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext());
        }
        return this;
    }

    private PositionRange makePositionRange(int n, int n2) {
        PositionRange positionRange = new PositionRange(n, n2);
        positionRange.setParentExpression(this.getParentExpression());
        positionRange.setLocationId(this.getLocationId());
        return positionRange;
    }

    private PositionRange makePositionRange(Expression expression, Expression expression2) {
        PositionRange positionRange = new PositionRange(expression, expression2);
        positionRange.setParentExpression(this.getParentExpression());
        positionRange.setLocationId(this.getLocationId());
        return positionRange;
    }

    public ValueComparison negate() {
        ValueComparison valueComparison = new ValueComparison(this.operand0, Token.negate(this.operator), this.operand1);
        valueComparison.comparer = this.comparer;
        valueComparison.resultWhenEmpty = this.resultWhenEmpty == null || this.resultWhenEmpty == BooleanValue.FALSE ? BooleanValue.TRUE : BooleanValue.FALSE;
        valueComparison.setLocationId(this.getLocationId());
        return valueComparison;
    }

    private static boolean isZero(Expression expression) {
        try {
            if (!(expression instanceof AtomicValue)) {
                return false;
            }
            if (expression instanceof IntegerValue) {
                return ((IntegerValue)expression).longValue() == 0L;
            }
            if (expression instanceof BigIntegerValue) {
                return ((BigIntegerValue)expression).compareTo(BigIntegerValue.ZERO) == 0;
            }
            AtomicValue atomicValue = ((AtomicValue)expression).convert(532, null);
            return ValueComparison.isZero(atomicValue);
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(513, xPathContext);
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(513, xPathContext);
            }
            return ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer);
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer) throws DynamicError {
        if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) {
            return n == 45;
        }
        if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
            return n == 45;
        }
        try {
            switch (n) {
                case 44: {
                    return atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 45: {
                    return !atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 46: {
                    return atomicComparer.compare(atomicValue, atomicValue2) > 0;
                }
                case 47: {
                    return atomicComparer.compare(atomicValue, atomicValue2) < 0;
                }
                case 48: {
                    return atomicComparer.compare(atomicValue, atomicValue2) >= 0;
                }
                case 49: {
                    return atomicComparer.compare(atomicValue, atomicValue2) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + n);
        }
        catch (ClassCastException classCastException) {
            DynamicError dynamicError = new DynamicError("Cannot compare " + atomicValue.getItemType(null) + " to " + atomicValue2.getItemType(null));
            dynamicError.setErrorCode("XPTY0004");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return this.resultWhenEmpty;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(513, xPathContext);
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return this.resultWhenEmpty;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(513, xPathContext);
            }
            return BooleanValue.get(ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer));
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        if (this.resultWhenEmpty != null) {
            return 16384;
        }
        return super.computeCardinality();
    }

    protected String displayOperator() {
        return Token.tokens[this.operator] + (this.resultWhenEmpty == null ? "" : " (on empty return " + this.resultWhenEmpty + ')');
    }
}

