/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.ImportedFunctionLibrary;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.UnboundFunctionLibrary;
import net.sf.saxon.query.UndeclaredVariable;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.variables.VariableResolver;
import org.xml.sax.SAXParseException;

public class StaticQueryContext
implements StaticContext {
    private boolean isMainModule;
    private Configuration config;
    private NamePool namePool;
    private String locationURI;
    private String moduleNamespace;
    private String baseURI;
    private HashMap passiveNamespaces;
    private HashSet explicitPrologNamespaces;
    private Stack activeNamespaces;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private NamespaceResolver externalNamespaceResolver = null;
    private VariableResolver variableResolver;
    private HashMap collations;
    private IntHashMap variables;
    private IntHashMap libraryVariables;
    private IntHashMap undeclaredVariables;
    private HashSet importedSchemata;
    private String defaultCollationName;
    private String defaultFunctionNamespace;
    private short defaultElementNamespace;
    private SlotManager stackFrameMap;
    private short moduleNamespaceURICode;
    private ModuleURIResolver moduleURIResolver;
    private int constructionMode;
    private Executable executable;
    private List importers;
    private FunctionLibraryList functionLibraryList;
    private XQueryFunctionLibrary globalFunctionLibrary;
    private int localFunctionLibraryNr;
    private int importedFunctionLibraryNr;
    private int unboundFunctionLibraryNr;
    private Set importedModuleNamespaces;
    private ErrorListener errorListener;

    private StaticQueryContext() {
    }

    public StaticQueryContext(Configuration config) {
        this.config = config;
        this.namePool = config.getNamePool();
        this.errorListener = config.getErrorListener();
        this.moduleURIResolver = config.getModuleURIResolver();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.isMainModule = true;
        this.reset();
    }

    public StaticQueryContext(Configuration config, StaticQueryContext importer) {
        this.config = config;
        this.namePool = config.getNamePool();
        this.isMainModule = false;
        if (this.importers == null && importer != null) {
            this.importers = new ArrayList(2);
            this.importers.add(importer);
        }
        this.reset();
    }

    public void reset() {
        this.passiveNamespaces = new HashMap(10);
        this.explicitPrologNamespaces = new HashSet(10);
        this.activeNamespaces = new Stack();
        this.externalNamespaceResolver = null;
        this.collations = new HashMap(5);
        this.variables = new IntHashMap(10);
        this.undeclaredVariables = new IntHashMap(5);
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        if (this.isTopLevelModule()) {
            this.globalFunctionLibrary = new XQueryFunctionLibrary(this.config);
            this.libraryVariables = new IntHashMap(10);
        }
        this.importedSchemata = new HashSet(5);
        this.importedModuleNamespaces = new HashSet(5);
        this.defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
        this.defaultElementNamespace = 0;
        this.moduleNamespace = null;
        this.moduleNamespaceURICode = 0;
        this.moduleURIResolver = this.config.getModuleURIResolver();
        this.constructionMode = 3;
        this.defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        this.declareCollation(this.defaultCollationName, CodepointCollator.getInstance());
        this.functionLibraryList = new FunctionLibraryList();
        this.functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(0));
        this.functionLibraryList.addFunctionLibrary(this.config.getVendorFunctionLibrary());
        this.functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.config));
        if (this.config.isAllowExternalFunctions()) {
            this.functionLibraryList.addFunctionLibrary(this.config.getExtensionBinder());
        }
        this.localFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new XQueryFunctionLibrary(this.config));
        this.importedFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new ImportedFunctionLibrary(this, this.getTopLevelModule(this).getGlobalFunctionLibrary()));
        this.unboundFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new UnboundFunctionLibrary());
        this.clearPassiveNamespaces();
    }

    public boolean isTopLevelModule() {
        return this.importers == null;
    }

    public boolean isMainModule() {
        return this.isMainModule;
    }

    public boolean mayImport(String namespace) {
        if (namespace.equals(this.moduleNamespace)) {
            return false;
        }
        if (this.importers == null) {
            return true;
        }
        for (int i = 0; i < this.importers.size(); ++i) {
            if (((StaticQueryContext)this.importers.get(i)).mayImport(namespace)) continue;
            return false;
        }
        return true;
    }

    public XQueryFunctionLibrary getGlobalFunctionLibrary() {
        return this.globalFunctionLibrary;
    }

    public ImportedFunctionLibrary getImportedFunctionLibrary() {
        return (ImportedFunctionLibrary)this.functionLibraryList.get(this.importedFunctionLibraryNr);
    }

    public void addImportedNamespace(String uri) {
        if (this.importedModuleNamespaces == null) {
            this.importedModuleNamespaces = new HashSet(5);
        }
        this.importedModuleNamespaces.add(uri);
        this.getImportedFunctionLibrary().addImportedNamespace(uri);
    }

    public boolean importsNamespace(String uri) {
        return this.importedModuleNamespaces != null && this.importedModuleNamespaces.contains(uri);
    }

    public boolean importsNamespaceIndirectly(String uri) {
        if (this.importsNamespace(uri)) {
            return true;
        }
        Iterator it = this.iterateImportedNamespaces();
        while (it.hasNext()) {
            String moduleURI = (String)it.next();
            List list = this.executable.getQueryLibraryModules(moduleURI);
            Iterator i2 = list.iterator();
            while (i2.hasNext()) {
                StaticQueryContext sqc = (StaticQueryContext)i2.next();
                if (!sqc.importsNamespaceIndirectly(uri)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator iterateImportedNamespaces() {
        if (this.importedModuleNamespaces == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.importedModuleNamespaces.iterator();
    }

    public StaticQueryContext getTopLevelModule(StaticQueryContext start) {
        if (this.importers == null) {
            return this;
        }
        for (int i = 0; i < this.importers.size(); ++i) {
            StaticQueryContext importer = (StaticQueryContext)this.importers.get(i);
            if (start.importsNamespace(importer.getModuleNamespace())) continue;
            return importer.getTopLevelModule(start);
        }
        return ((StaticQueryContext)this.importers.get(0)).getTopLevelModule(start);
    }

    public StaticQueryContext copy() {
        StaticQueryContext n = new StaticQueryContext();
        n.config = this.config;
        n.namePool = this.namePool;
        n.isMainModule = this.isMainModule;
        n.passiveNamespaces = new HashMap(this.passiveNamespaces);
        n.explicitPrologNamespaces = new HashSet(this.explicitPrologNamespaces);
        n.activeNamespaces = new Stack();
        n.externalNamespaceResolver = this.externalNamespaceResolver;
        n.variableResolver = this.variableResolver;
        n.inheritNamespaces = this.inheritNamespaces;
        n.preserveNamespaces = this.preserveNamespaces;
        n.collations = new HashMap(this.collations);
        n.variables = this.variables.copy();
        n.undeclaredVariables = this.undeclaredVariables.copy();
        if (this.libraryVariables != null) {
            n.libraryVariables = this.libraryVariables.copy();
        }
        n.importedSchemata = new HashSet(this.importedSchemata);
        n.defaultCollationName = this.defaultCollationName;
        n.defaultFunctionNamespace = this.defaultFunctionNamespace;
        n.defaultElementNamespace = this.defaultElementNamespace;
        n.locationURI = this.locationURI;
        n.baseURI = this.baseURI;
        n.stackFrameMap = this.stackFrameMap;
        n.moduleNamespace = this.moduleNamespace;
        n.moduleNamespaceURICode = this.moduleNamespaceURICode;
        n.moduleURIResolver = this.moduleURIResolver;
        n.constructionMode = this.constructionMode;
        n.executable = this.executable;
        n.importers = this.importers;
        n.functionLibraryList = (FunctionLibraryList)this.functionLibraryList.copy();
        n.localFunctionLibraryNr = this.localFunctionLibraryNr;
        n.importedFunctionLibraryNr = this.importedFunctionLibraryNr;
        n.unboundFunctionLibraryNr = this.unboundFunctionLibraryNr;
        n.globalFunctionLibrary = this.globalFunctionLibrary;
        n.importedModuleNamespaces = new HashSet(this.importedModuleNamespaces);
        n.getImportedFunctionLibrary().setImportingModule(n);
        return n;
    }

    public void setConfiguration(Configuration config) {
        if (this.config != config) {
            throw new IllegalArgumentException("Configuration cannot be changed dynamically");
        }
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this);
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        Source s2 = this.config.getSourceResolver().resolveSource(source, this.config);
        if (s2 != null) {
            source = s2;
        }
        AllElementStripper stripper = null;
        if (this.config.isStripsAllWhiteSpace()) {
            stripper = AllElementStripper.getInstance();
            stripper.setStripAll();
        }
        try {
            NodeInfo contextNode = Builder.build(source, (Stripper)stripper, this.config);
            return contextNode.getDocumentRoot();
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err);
                }
            } else {
                while (err.getException() instanceof XPathException) {
                    err = (XPathException)err.getException();
                }
                this.reportFatalError(err);
            }
            throw err;
        }
    }

    public XQueryExpression compileQuery(String query) throws XPathException {
        QueryParser qp = new QueryParser();
        XQueryExpression queryExp = qp.makeXQueryExpression(query, this.copy(), this.config);
        return queryExp;
    }

    public XQueryExpression compileQuery(Reader source) throws XPathException, IOException {
        int n;
        char[] buffer = new char[4096];
        StringBuffer sb = new StringBuffer(4096);
        while ((n = source.read(buffer)) > 0) {
            sb.append(buffer, 0, n);
        }
        return this.compileQuery(sb.toString());
    }

    public XQueryExpression compileQuery(InputStream source, String encoding) throws XPathException, IOException {
        String query = QueryReader.readInputStream(source, encoding, this.config.getNameChecker());
        return this.compileQuery(query);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public LocationMap getLocationMap() {
        return this.executable.getLocationMap();
    }

    public void declarePassiveNamespace(String prefix, String uri, boolean explicit) throws StaticError {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declarePassiveNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePassiveNamespace()");
        }
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            StaticError err = new StaticError("Invalid declaration of the XML namespace");
            err.setErrorCode("XQST0070");
            throw err;
        }
        if (explicit) {
            if (uri.equals("") && !prefix.equals("")) {
                this.explicitPrologNamespaces.remove(prefix);
            } else {
                if (this.explicitPrologNamespaces.contains(prefix)) {
                    StaticError err = new StaticError("Duplicate declaration of namespace prefix \"" + prefix + '\"');
                    err.setErrorCode("XQST0033");
                    throw err;
                }
                this.explicitPrologNamespaces.add(prefix);
            }
        }
        if (uri.equals("") && !prefix.equals("")) {
            this.passiveNamespaces.remove(prefix);
        } else {
            this.passiveNamespaces.put(prefix, uri);
            this.namePool.allocateNamespaceCode(prefix, uri);
        }
    }

    public void declareActiveNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        int nscode = this.namePool.allocateNamespaceCode(prefix, uri);
        ActiveNamespace entry = new ActiveNamespace();
        entry.prefix = prefix;
        entry.uri = uri;
        entry.code = nscode;
        this.activeNamespaces.push(entry);
        if (prefix.equals("")) {
            this.defaultElementNamespace = (short)(nscode & 0xFFFF);
        }
    }

    public void undeclareNamespace() {
        ActiveNamespace entry = (ActiveNamespace)this.activeNamespaces.pop();
        if (entry.prefix.equals("")) {
            for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
                if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals("")) continue;
                this.defaultElementNamespace = (short)(((ActiveNamespace)this.activeNamespaces.get((int)i)).code & 0xFFFF);
                return;
            }
            String defaultNS = (String)this.passiveNamespaces.get("");
            this.defaultElementNamespace = "".equals(defaultNS) ? (short)0 : this.getNamePool().getCodeForURI(defaultNS);
        }
    }

    public void clearPassiveNamespaces() {
        try {
            if (this.passiveNamespaces != null) {
                this.passiveNamespaces.clear();
                this.declarePassiveNamespace("xml", "http://www.w3.org/XML/1998/namespace", false);
                this.declarePassiveNamespace("saxon", "http://saxon.sf.net/", false);
                this.declarePassiveNamespace("xs", "http://www.w3.org/2001/XMLSchema", false);
                this.declarePassiveNamespace("fn", "http://www.w3.org/2005/xpath-functions", false);
                this.declarePassiveNamespace("xdt", "http://www.w3.org/2005/xpath-datatypes", false);
                this.declarePassiveNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance", false);
                this.declarePassiveNamespace("local", "http://www.w3.org/2005/xquery-local-functions", false);
                this.declarePassiveNamespace("", "", false);
            }
        }
        catch (StaticError staticError) {
            throw new IllegalStateException("Internal Failure initializing namespace declarations");
        }
    }

    public void setExternalNamespaceResolver(NamespaceResolver resolver) {
        this.externalNamespaceResolver = resolver;
    }

    public NamespaceResolver getExternalNamespaceResolver() {
        return this.externalNamespaceResolver;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver aVariableResolver) {
        this.variableResolver = aVariableResolver;
    }

    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.checkURIForPrefix(prefix);
        if (uri == null) {
            StaticError err = new StaticError("Prefix " + prefix + " has not been declared");
            err.setErrorCode("XPST0081");
            throw err;
        }
        return uri;
    }

    public String checkURIForPrefix(String prefix) {
        for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
            if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals(prefix)) continue;
            return ((ActiveNamespace)this.activeNamespaces.get((int)i)).uri;
        }
        String uri = (String)this.passiveNamespaces.get(prefix);
        if (uri != null) {
            return uri;
        }
        if (this.externalNamespaceResolver != null) {
            return this.externalNamespaceResolver.getURIForPrefix(prefix, true);
        }
        return null;
    }

    public int[] getActiveNamespaceCodes() {
        int[] nscodes = new int[this.activeNamespaces.size()];
        int used = 0;
        HashSet<String> prefixes = new HashSet<String>(10);
        for (int n = this.activeNamespaces.size() - 1; n >= 0; --n) {
            ActiveNamespace an = (ActiveNamespace)this.activeNamespaces.get(n);
            if (prefixes.contains(an.prefix)) continue;
            prefixes.add(an.prefix);
            nscodes[used++] = an.code;
        }
        if (used < nscodes.length) {
            int[] nscodes2 = new int[used];
            System.arraycopy(nscodes, 0, nscodes2, 0, used);
            nscodes = nscodes2;
        }
        return nscodes;
    }

    public NamespaceResolver getNamespaceResolver() {
        int[] active = this.getActiveNamespaceCodes();
        int[] nscodes = new int[this.passiveNamespaces.size() + active.length];
        int used = 0;
        Iterator iter = this.passiveNamespaces.keySet().iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = (String)this.passiveNamespaces.get(prefix);
            nscodes[used++] = this.namePool.getNamespaceCode(prefix, uri);
        }
        for (int a = 0; a < active.length; ++a) {
            nscodes[used++] = active[a];
        }
        return new SavedNamespaceContext(nscodes, this.namePool);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String defaultFunctionNamespace) {
        this.defaultFunctionNamespace = defaultFunctionNamespace;
    }

    public void setDefaultElementNamespace(String uri) throws StaticError {
        int nscode = this.namePool.allocateNamespaceCode("", uri);
        this.defaultElementNamespace = (short)(nscode & 0xFFFF);
        this.declarePassiveNamespace("", uri, true);
    }

    public short getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setModuleNamespace(String uri) {
        this.moduleNamespace = uri;
        this.moduleNamespaceURICode = this.namePool.getCodeForURI(uri);
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public short getModuleNamespaceCode() {
        return this.moduleNamespaceURICode;
    }

    public void setLocationURI(String uri) {
        this.locationURI = uri;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean inherit) {
        this.preserveNamespaces = inherit;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void declareCollation(String name, Comparator comparator) {
        this.collations.put(name, comparator);
    }

    public void declareDefaultCollation(String name) {
        this.defaultCollationName = name;
    }

    public Comparator getCollation(String name) {
        Comparator c = (Comparator)this.collations.get(name);
        if (c != null) {
            return c;
        }
        return this.config.getCollationURIResolver().resolve(name, this.getBaseURI(), this.config);
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public HashMap getAllCollations() {
        return new HashMap(this.collations);
    }

    public SlotManager getGlobalStackFrameMap() {
        return this.executable.getGlobalVariableMap();
    }

    public void declareVariable(VariableDeclaration var) throws StaticError {
        GlobalVariableDefinition old;
        int key = var.getNameCode() & 0xFFFFF;
        if (this.variables.get(key) != null && (old = (GlobalVariableDefinition)this.variables.get(key)) != var) {
            StaticError err = new StaticError("Duplicate definition of global variable " + var.getVariableName() + " (see line " + old.getLineNumber() + ')');
            err.setErrorCode("XQST0049");
            if (var instanceof GlobalVariableDefinition) {
                ExpressionLocation loc = new ExpressionLocation();
                loc.setLineNumber(((GlobalVariableDefinition)var).getLineNumber());
                loc.setSystemId(((GlobalVariableDefinition)var).getSystemId());
                err.setLocator(loc);
            }
            throw err;
        }
        this.variables.put(key, var);
        IntHashMap libVars = this.getTopLevelModule((StaticQueryContext)this).libraryVariables;
        GlobalVariableDefinition old2 = (GlobalVariableDefinition)libVars.get(key);
        if (old2 != null && old2 != var) {
            StaticError err = new StaticError("Duplicate definition of global variable " + var.getVariableName() + " (see line " + old2.getLineNumber() + " in module " + old2.getSystemId() + ')');
            err.setErrorCode("XQST0049");
            if (var instanceof GlobalVariableDefinition) {
                ExpressionLocation loc = new ExpressionLocation();
                loc.setLineNumber(((GlobalVariableDefinition)var).getLineNumber());
                loc.setSystemId(((GlobalVariableDefinition)var).getSystemId());
                err.setLocator(loc);
            }
            throw err;
        }
        if (!this.isTopLevelModule()) {
            libVars.put(key, var);
        }
    }

    public List fixupGlobalVariables(SlotManager globalVariableMap) throws StaticError {
        ArrayList<GlobalVariable> compiledVars = new ArrayList<GlobalVariable>(20);
        Iterator[] iters = new Iterator[]{this.variables.valueIterator(), this.libraryVariables.valueIterator()};
        for (int i = 0; i < 2; ++i) {
            while (iters[i].hasNext()) {
                GlobalVariableDefinition var = (GlobalVariableDefinition)iters[i].next();
                try {
                    int slot = globalVariableMap.allocateSlotNumber(var.getNameCode() & 0xFFFFF);
                    GlobalVariable gv = var.getCompiledVariable();
                    if (gv == null) {
                        gv = var.compile(this, slot);
                    }
                    if (compiledVars.contains(gv)) continue;
                    compiledVars.add(gv);
                }
                catch (XPathException err) {
                    throw StaticError.makeStaticError(err);
                }
            }
        }
        return compiledVars;
    }

    public Iterator getModuleVariables() {
        return this.variables.valueIterator();
    }

    public void typeCheckGlobalVariables(List compiledVars) throws StaticError {
        try {
            Iterator iter = compiledVars.iterator();
            Stack stack = new Stack();
            while (iter.hasNext()) {
                GlobalVariable gv = (GlobalVariable)iter.next();
                gv.lookForCycles(stack);
                GlobalVariableDefinition.typeCheck(this, gv);
            }
        }
        catch (XPathException e) {
            throw StaticError.makeStaticError(e);
        }
    }

    public void explainGlobalVariables() {
        Iterator iter = this.variables.valueIterator();
        while (iter.hasNext()) {
            GlobalVariableDefinition var = (GlobalVariableDefinition)iter.next();
            var.explain(this.getConfiguration());
        }
    }

    public SlotManager getStackFrameMap() {
        if (this.stackFrameMap == null) {
            this.stackFrameMap = this.getConfiguration().makeSlotManager();
        }
        return this.stackFrameMap;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String s, SourceLocator locator) {
        StaticError err = new StaticError(s);
        err.setLocator(locator);
        try {
            this.config.getErrorListener().warning(err);
        }
        catch (TransformerException e) {
            // empty catch block
        }
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public VariableReference bindVariable(int fingerprint) throws StaticError {
        VariableDeclaration var = (VariableDeclaration)this.variables.get(fingerprint);
        if (var == null) {
            String uri = this.getNamePool().getURI(fingerprint);
            String local = this.getNamePool().getLocalName(fingerprint);
            if (this.importedModuleNamespaces.contains(uri)) {
                StaticQueryContext main = this.getTopLevelModule(this);
                var = (VariableDeclaration)main.libraryVariables.get(fingerprint);
                if (var == null) {
                    UndeclaredVariable uvar = new UndeclaredVariable();
                    uvar.setNameCode(fingerprint);
                    uvar.setVariableName(this.getNamePool().getDisplayName(fingerprint));
                    VariableReference ref = new VariableReference(uvar);
                    this.undeclaredVariables.put(fingerprint, uvar);
                    return ref;
                }
                GlobalVariableDefinition gvar = (GlobalVariableDefinition)var;
                this.checkImportedType(gvar.getRequiredType(), gvar);
            } else if (this.getVariableResolver() != null) {
                if (this.getVariableResolver().hasVariable(fingerprint, uri, local)) {
                    var = this.getVariableResolver().resolve(fingerprint, uri, local);
                    this.declareVariable(var);
                }
            } else {
                StaticError err = new StaticError("Unresolved reference to variable");
                err.setErrorCode("XPST0008");
                throw err;
            }
        }
        return new VariableReference(var);
    }

    public void setFunctionLibraryList(FunctionLibraryList functionLibrary) {
        this.functionLibraryList = functionLibrary;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibraryList;
    }

    public XQueryFunctionLibrary getLocalFunctionLibrary() {
        return (XQueryFunctionLibrary)this.functionLibraryList.get(this.localFunctionLibraryNr);
    }

    public void declareFunction(XQueryFunction function) throws StaticError {
        SchemaType t;
        if (function.getNumberOfArguments() == 1 && (t = this.config.getSchemaType(function.getNameCode() & 0xFFFFF)) != null && t instanceof AtomicType) {
            StaticError err = new StaticError("Function name " + function.getFunctionDisplayName(this.getNamePool()) + " clashes with the name of the constructor function for an atomic type");
            err.setErrorCode("XQST0034");
            throw err;
        }
        XQueryFunctionLibrary local = this.getLocalFunctionLibrary();
        local.declareFunction(function);
        StaticQueryContext main = this.getTopLevelModule(this);
        main.globalFunctionLibrary.declareFunction(function);
    }

    public void bindUnboundFunctionCalls() throws XPathException {
        UnboundFunctionLibrary lib = (UnboundFunctionLibrary)this.functionLibraryList.get(this.unboundFunctionLibraryNr);
        lib.bindUnboundFunctionCalls(this.functionLibraryList, this.config);
    }

    public void fixupGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.fixupGlobalFunctions(this);
    }

    public void explainGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.explainGlobalFunctions();
    }

    public UserFunction getUserDefinedFunction(String uri, String localName, int arity) {
        return this.globalFunctionLibrary.getUserDefinedFunction(uri, localName, arity);
    }

    public void bindUnboundVariables() throws XPathException {
        Iterator iter = this.undeclaredVariables.valueIterator();
        while (iter.hasNext()) {
            String uri;
            UndeclaredVariable uv = (UndeclaredVariable)iter.next();
            int fingerprint = uv.getNameCode() & 0xFFFFF;
            VariableDeclaration var = (VariableDeclaration)this.variables.get(fingerprint);
            if (var == null && this.importedModuleNamespaces.contains(uri = this.getNamePool().getURI(fingerprint))) {
                StaticQueryContext main = this.getTopLevelModule(this);
                var = (VariableDeclaration)main.libraryVariables.get(fingerprint);
            }
            if (var == null) {
                StaticError err = new StaticError("Unresolved reference to variable $" + uv.getVariableName());
                err.setErrorCode("XPST0008");
                throw err;
            }
            GlobalVariableDefinition gvar = (GlobalVariableDefinition)var;
            this.checkImportedType(gvar.getRequiredType(), gvar);
            uv.transferReferences(var);
        }
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public void addImportedSchema(String targetNamespace) {
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet(5);
        }
        this.importedSchemata.add(targetNamespace);
    }

    public boolean isImportedSchema(String namespace) {
        if (this.importedSchemata == null) {
            return false;
        }
        return this.importedSchemata.contains(namespace);
    }

    public Set getImportedSchemaNamespaces() {
        return this.importedSchemata;
    }

    public boolean isAllowedBuiltInType(AtomicType type) {
        return true;
    }

    public void setConstructionMode(int mode) {
        this.constructionMode = mode;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public static StaticQueryContext makeStaticQueryContext(String baseURI, Executable executable, StaticQueryContext importer, String query, String namespaceURI) throws StaticError {
        Configuration config = executable.getConfiguration();
        StaticQueryContext module = new StaticQueryContext(config, importer);
        module.setLocationURI(baseURI);
        module.setBaseURI(baseURI);
        module.setModuleNamespace(namespaceURI);
        module.setExecutable(executable);
        if (importer != null) {
            module.setModuleURIResolver(importer.getModuleURIResolver());
        }
        executable.addQueryLibraryModule(module);
        QueryParser qp = new QueryParser();
        qp.parseLibraryModule(query, module);
        if (module.getModuleNamespace() == null) {
            StaticError err = new StaticError("Imported module must be a library module");
            err.setErrorCode("XQST0059");
            throw err;
        }
        if (!module.getModuleNamespace().equals(namespaceURI)) {
            StaticError err = new StaticError("Imported module's namespace does not match requested namespace");
            err.setErrorCode("XQST0059");
            throw err;
        }
        return module;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        if (this.errorListener == null) {
            this.errorListener = this.config.getErrorListener();
        }
        return this.errorListener;
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            err.setHasBeenReported();
        }
    }

    public void checkImportedType(SequenceType importedType, Declaration declaration) throws StaticError {
        ItemType type = importedType.getPrimaryType();
        if (type instanceof AnyItemType) {
            return;
        }
        if (type instanceof AtomicType) {
            int f = ((AtomicType)type).getFingerprint();
            QueryReader.checkSchemaNamespaceImported(this, f, declaration);
        } else if (type instanceof ContentTypeTest) {
            SchemaType annotation = ((ContentTypeTest)type).getSchemaType();
            int f = annotation.getFingerprint();
            QueryReader.checkSchemaNamespaceImported(this, f, declaration);
        } else if (type instanceof CombinedNodeTest) {
            NodeTest[] tests = ((CombinedNodeTest)type).getComponentNodeTests();
            for (int i = 0; i < tests.length; ++i) {
                SequenceType st = SequenceType.makeSequenceType(tests[1], 16384);
                this.checkImportedType(st, declaration);
            }
        }
    }

    private static class ActiveNamespace {
        public String prefix;
        public String uri;
        public int code;

        private ActiveNamespace() {
        }
    }
}

