/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class XQueryFunction
implements InstructionInfo,
Container,
Declaration {
    private int nameCode;
    List arguments;
    SequenceType resultType;
    Expression body = null;
    List references = new ArrayList(10);
    int lineNumber;
    int columnNumber;
    String systemId;
    private Executable executable;
    private UserFunction compiledFunction = null;
    NamespaceResolver namespaceResolver;
    StaticContext staticContext;

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public String getFunctionDisplayName(NamePool namePool) {
        return namePool.getDisplayName(this.nameCode);
    }

    public int getFunctionFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public LocationProvider getLocationProvider() {
        return this.executable.getLocationMap();
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] sequenceTypeArray = new SequenceType[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            sequenceTypeArray[i] = ((RangeVariableDeclaration)this.arguments.get(i)).getRequiredType();
        }
        return sequenceTypeArray;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        UserFunctionParameter[] userFunctionParameterArray = new UserFunctionParameter[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            SequenceType sequenceType = ((RangeVariableDeclaration)this.arguments.get(i)).getRequiredType();
            UserFunctionParameter userFunctionParameter = new UserFunctionParameter();
            userFunctionParameter.setRequiredType(sequenceType);
            userFunctionParameterArray[i] = userFunctionParameter;
        }
        return userFunctionParameterArray;
    }

    public int getNumberOfArguments() {
        return this.arguments.size();
    }

    public void registerReference(UserFunctionCall userFunctionCall) {
        this.references.add(userFunctionCall);
    }

    public UserFunction compile(StaticQueryContext staticQueryContext) throws StaticError {
        try {
            Serializable serializable;
            if (this.compiledFunction == null) {
                Serializable serializable2;
                Object object;
                serializable = staticQueryContext.getConfiguration().makeSlotManager();
                UserFunctionParameter[] userFunctionParameterArray = this.getParameterDefinitions();
                Iterator iterator = this.arguments.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object = (RangeVariableDeclaration)iterator.next();
                    serializable2 = userFunctionParameterArray[n];
                    ((UserFunctionParameter)serializable2).setSlotNumber(n++);
                    ((UserFunctionParameter)serializable2).setRequiredType(((RangeVariableDeclaration)object).getRequiredType());
                    ((SlotManager)serializable).allocateSlotNumber(((RangeVariableDeclaration)object).getNameCode() & 0xFFFFF);
                    ((RangeVariableDeclaration)object).fixupReferences((Binding)((Object)serializable2));
                }
                this.body = this.body.simplify(this.staticContext).typeCheck(this.staticContext, null);
                this.body = this.body.optimize(this.staticContext.getConfiguration().getOptimizer(), this.staticContext, null);
                if (this.body instanceof ComputedExpression) {
                    ((ComputedExpression)this.body).setParentExpression(this);
                }
                object = new RoleLocator(5, new Integer(this.nameCode), 0, staticQueryContext.getNamePool());
                ((RoleLocator)object).setSourceLocator(this);
                this.body = TypeChecker.staticTypeCheck(this.body, this.resultType, false, (RoleLocator)object, staticQueryContext);
                if (this.body instanceof ComputedExpression) {
                    ((ComputedExpression)this.body).setParentExpression(this);
                }
                ExpressionTool.allocateSlots(this.body, n, (SlotManager)serializable);
                if (staticQueryContext.getConfiguration().getTraceListener() != null) {
                    this.namespaceResolver = staticQueryContext.getNamespaceResolver();
                    serializable2 = new TraceExpression(this.body);
                    ((TraceExpression)serializable2).setLineNumber(this.lineNumber);
                    ((TraceExpression)serializable2).setColumnNumber(this.columnNumber);
                    ((TraceExpression)serializable2).setSystemId(staticQueryContext.getBaseURI());
                    ((TraceExpression)serializable2).setConstructType(149);
                    ((TraceExpression)serializable2).setObjectNameCode(this.nameCode);
                    ((ComputedExpression)serializable2).setLocationId(staticQueryContext.getLocationMap().allocateLocationId(this.systemId, this.lineNumber));
                    this.body = serializable2;
                }
                this.compiledFunction = new UserFunction(this.body);
                this.compiledFunction.setHostLanguage(51);
                this.compiledFunction.setFunctionNameCode(this.nameCode);
                this.compiledFunction.setParameterDefinitions(userFunctionParameterArray);
                this.compiledFunction.setResultType(this.getResultType());
                this.compiledFunction.setLineNumber(this.lineNumber);
                this.compiledFunction.setSystemId(this.systemId);
                this.compiledFunction.setExecutable(this.executable);
                this.compiledFunction.setStackFrameMap((SlotManager)serializable);
                boolean bl = ExpressionTool.markTailFunctionCalls(this.body);
                this.compiledFunction.setTailRecursive(bl);
                for (int i = 0; i < userFunctionParameterArray.length; ++i) {
                    RangeVariableDeclaration rangeVariableDeclaration = (RangeVariableDeclaration)this.arguments.get(i);
                    UserFunctionParameter userFunctionParameter = userFunctionParameterArray[i];
                    int n2 = rangeVariableDeclaration.getReferenceCount(userFunctionParameter, this.staticContext);
                    userFunctionParameter.setReferenceCount(n2);
                }
            }
            this.fixupReferences(this.staticContext);
            if (!(this.executable.getFunctionLibrary() instanceof ExecutableFunctionLibrary)) {
                throw new AssertionError((Object)("executable.getFunctionLibrary() is an instance of " + this.executable.getFunctionLibrary().getClass().getName()));
            }
            serializable = (ExecutableFunctionLibrary)this.executable.getFunctionLibrary();
            ((ExecutableFunctionLibrary)serializable).addFunction(this.compiledFunction);
            return this.compiledFunction;
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            if (xPathException instanceof StaticError) {
                throw (StaticError)xPathException;
            }
            throw new StaticError(xPathException);
        }
    }

    public void fixupReferences(StaticContext staticContext) throws XPathException {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            userFunctionCall.setFunction(this.compiledFunction, staticContext);
        }
    }

    public void checkReferences(StaticContext staticContext) throws XPathException {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            userFunctionCall.checkFunctionCall(this.compiledFunction, staticContext);
        }
        this.references = new ArrayList(0);
    }

    public void explain(Configuration configuration) {
        NamePool namePool = configuration.getNamePool();
        System.err.println("declare function " + namePool.getDisplayName(this.nameCode) + (this.compiledFunction.isTailRecursive() ? "(:tail recursive:) {" : " {"));
        this.body.display(4, System.err, configuration);
        System.err.println("}");
    }

    public UserFunction getUserFunction() {
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 149;
    }

    public int getObjectNameCode() {
        return this.nameCode;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public Object getProperty(String string) {
        if ("name".equals(string)) {
            return this.staticContext.getNamePool().getDisplayName(this.nameCode);
        }
        if ("as".equals(string)) {
            return this.resultType.toString();
        }
        return null;
    }

    public Iterator getProperties() {
        return new PairIterator("name", "as");
    }

    public int getHostLanguage() {
        return 51;
    }
}

