/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Err;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.sort.IntHashSet;

public class JDK14RegexTranslator {
    private CharSequence regExp;
    private boolean isXPath;
    private int pos = 0;
    private int length;
    private char curChar;
    private boolean eos = false;
    private final FastStringBuffer result = new FastStringBuffer(32);
    private int currentCapture = 0;
    private IntHashSet captures = new IntHashSet();
    private static final String categories = "LMNPZSC";
    private static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private static final int NONBMP_MIN = 65536;
    private static final int NONBMP_MAX = 0x10FFFF;
    private static final char SURROGATE2_MIN = '\udc00';
    private static final char SURROGATE2_MAX = '\udfff';
    private static final String[] blockNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-B", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-B", "Specials", "HalfwidthandFullwidthForms", "Specials"};
    private static final String[] specialBlockNames = new String[]{"OldItalic", "Gothic", "Deseret", "ByzantineMusicalSymbols", "MusicalSymbols", "MathematicalAlphanumericSymbols", "CJKUnifiedIdeographsExtensionB", "CJKCompatibilityIdeographsSupplement", "Tags", "PrivateUse", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates"};
    static final String CATEGORY_NAMES = "NoLoMnCfLlNlPoLuMcNdSoSmCo";
    static final int[][] CATEGORY_RANGES = new int[][]{{65799, 65843, 66336, 66339}, {65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 66304, 66334, 66352, 66377, 66432, 66461, 66640, 66717, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67647, 131072, 173782, 194560, 195101}, {119143, 119145, 119163, 119170, 119173, 119179, 119210, 119213, 917760, 917999}, {119155, 119162, 917505, 917505, 917536, 917631}, {66600, 66639, 119834, 119859, 119886, 119892, 119894, 119911, 119938, 119963, 119990, 119993, 119995, 119995, 119997, 120003, 120005, 120015, 120042, 120067, 120094, 120119, 120146, 120171, 120198, 120223, 120250, 120275, 120302, 120327, 120354, 120379, 120406, 120431, 120458, 120483, 120514, 120538, 120540, 120545, 120572, 120596, 120598, 120603, 120630, 120654, 120656, 120661, 120688, 120712, 120714, 120719, 120746, 120770, 120772, 120777}, {66378, 66378}, {65792, 65793, 66463, 66463}, {66560, 66599, 119808, 119833, 119860, 119885, 119912, 119937, 119964, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119989, 120016, 120041, 120068, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120120, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120172, 120197, 120224, 120249, 120276, 120301, 120328, 120353, 120380, 120405, 120432, 120457, 120488, 120512, 120546, 120570, 120604, 120628, 120662, 120686, 120720, 120744}, {119141, 119142, 119149, 119154}, {66720, 66729, 120782, 120831}, {65794, 65794, 65847, 65855, 118784, 119029, 119040, 119078, 119082, 119140, 119146, 119148, 119171, 119172, 119180, 119209, 119214, 119261, 119552, 119638}, {120513, 120513, 120539, 120539, 120571, 120571, 120597, 120597, 120629, 120629, 120655, 120655, 120687, 120687, 120713, 120713, 120745, 120745, 120771, 120771}, {983040, 1048573, 0x100000, 1114109}};
    private static final CharClass[] specialBlockCharClasses = new CharClass[]{new CharRange(66304, 66351), new CharRange(66352, 66383), new CharRange(66560, 66639), new CharRange(118784, 119039), new CharRange(119040, 119295), new CharRange(119808, 120831), new CharRange(131072, 173782), new CharRange(194560, 195103), new CharRange(917504, 917631), new Union(new CharClass[]{new CharRange(57344, 63743), new CharRange(983040, 1048573), new CharRange(0x100000, 1114109)}), Empty.getInstance(), Empty.getInstance(), Empty.getInstance()};
    private static final CharClass DOT_SCHEMA = new Complement(new Union(new CharClass[]{new SingleChar('\n'), new SingleChar('\r')}));
    private static final CharClass DOT_XPATH = new Dot();
    private static final CharClass ESC_d = new Property("Nd");
    private static final CharClass ESC_D = new Complement(ESC_d);
    private static final CharClass ESC_W = new Union(new CharClass[]{JDK14RegexTranslator.computeCategoryCharClass('P'), JDK14RegexTranslator.computeCategoryCharClass('Z'), JDK14RegexTranslator.computeCategoryCharClass('C')});
    private static final CharClass ESC_w = new Complement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(' '), new SingleChar('\n'), new SingleChar('\r'), new SingleChar('\t')});
    static final String NMSTRT_INCLUDES = ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e";
    static final String NMSTRT_EXCLUDE_RANGES = "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc";
    static final String NMSTRT_CATEGORIES = "LlLuLoLtNl";
    static final String NMCHAR_INCLUDES = "-.:_\u00b7\u0387\u212e";
    static final String NMCHAR_EXCLUDE_RANGES = "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc";
    static final String NMCHAR_CATEGORIES = "LlLuLoLtNlMcMeMnLmNd";
    private static final CharClass ESC_S = new Complement(ESC_s);
    private static final CharClass ESC_i = JDK14RegexTranslator.makeCharClass("LlLuLoLtNl", ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e", "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_I = new Complement(ESC_i);
    private static final CharClass ESC_c = JDK14RegexTranslator.makeCharClass("LlLuLoLtNlMcMeMnLmNd", "-.:_\u00b7\u0387\u212e", "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_C = new Complement(ESC_c);
    private static final char EOS = '\u0000';
    static final int NONE = -1;
    static final int SOME = 0;
    static final int ALL = 1;
    static final String SURROGATES1_CLASS = "[\ud800-\udbff]";
    static final String SURROGATES2_CLASS = "[\udc00-\udfff]";
    static final String NOT_ALLOWED_CLASS = "[\u0000&&[^\u0000]]";
    private static final char UNICODE_3_1_ADD_Lu = '\u03f4';
    private static final char UNICODE_3_1_ADD_Ll = '\u03f5';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MIN = '\u16ee';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MAX = '\u16f0';
    private static final String CATEGORY_Pi = "\u00ab\u2018\u201b\u201c\u201f\u2039";
    private static final String CATEGORY_Pf = "\u00bb\u2019\u201d\u203a";

    public String translate(CharSequence charSequence, boolean bl) throws RegexSyntaxException {
        this.regExp = charSequence;
        this.isXPath = bl;
        this.length = charSequence.length();
        this.advance();
        this.translateTop();
        return this.result.toString();
    }

    public int getNumberOfCapturedGroups() {
        return this.currentCapture;
    }

    private void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    private void recede() {
        if (this.eos) {
            this.curChar = this.regExp.charAt(this.length - 1);
            this.pos = this.length;
            this.eos = false;
        } else {
            this.curChar = this.regExp.charAt(--this.pos);
        }
    }

    private void translateTop() throws RegexSyntaxException {
        this.translateRegExp();
        if (!this.eos) {
            throw this.makeException("expected end of string");
        }
    }

    private void translateRegExp() throws RegexSyntaxException {
        this.translateBranch();
        while (this.curChar == '|') {
            this.copyCurChar();
            this.translateBranch();
        }
    }

    private void translateBranch() throws RegexSyntaxException {
        while (this.translateAtom()) {
            this.translateQuantifier();
        }
    }

    private void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.copyCurChar();
                break;
            }
            case '{': {
                this.copyCurChar();
                this.translateQuantity();
                this.expect('}');
                this.copyCurChar();
                break;
            }
            default: {
                return;
            }
        }
        if (this.curChar == '?' && this.isXPath) {
            this.copyCurChar();
        }
    }

    private void translateQuantity() throws RegexSyntaxException {
        block7: {
            String string = ((Object)this.parseQuantExact()).toString();
            int n = -1;
            try {
                n = Integer.parseInt(string);
                this.result.append(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.result.append("2147483647");
            }
            if (this.curChar == ',') {
                this.copyCurChar();
                if (this.curChar != '}') {
                    String string2 = ((Object)this.parseQuantExact()).toString();
                    try {
                        int n2 = Integer.parseInt(string2);
                        this.result.append(string2);
                        if (n < 0 || n2 < n) {
                            throw this.makeException("invalid range in quantifier");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.result.append("2147483647");
                        if (n >= 0 || new BigDecimal(string).compareTo(new BigDecimal(string2)) <= 0) break block7;
                        throw this.makeException("invalid range in quantifier");
                    }
                }
            }
        }
    }

    private CharSequence parseQuantExact() throws RegexSyntaxException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(10);
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected digit in quantifier");
            }
            fastStringBuffer.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return fastStringBuffer;
    }

    private void copyCurChar() {
        this.result.append(this.curChar);
        this.advance();
    }

    private boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                int n = ++this.currentCapture;
                this.translateRegExp();
                this.expect(')');
                this.captures.add(n);
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                if (this.isXPath) {
                    DOT_XPATH.output(this.result);
                    this.advance();
                    return true;
                }
                DOT_SCHEMA.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                if (this.isXPath) {
                    this.copyCurChar();
                    return true;
                }
                this.result.append('\\');
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeCharClass(String string, String string2, String string3) {
        int n;
        int n2;
        ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>(5);
        int n3 = string.length();
        for (n2 = 0; n2 < n3; n2 += 2) {
            arrayList.add(new Property(string.substring(n2, n2 + 2)));
        }
        n3 = string2.length();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3 && string2.charAt(n) - string2.charAt(n2) == n - n2; ++n) {
            }
            if (n2 == --n - 1) {
                --n;
            }
            if (n2 == n) {
                arrayList.add(new SingleChar(string2.charAt(n2)));
            } else {
                arrayList.add(new CharRange(string2.charAt(n2), string2.charAt(n)));
            }
            n2 = n;
        }
        ArrayList<SimpleCharClass> arrayList2 = new ArrayList<SimpleCharClass>(5);
        n = string3.length();
        for (n3 = 0; n3 < n; n3 += 2) {
            char c;
            char c2 = string3.charAt(n3);
            if (c2 == (c = string3.charAt(n3 + 1))) {
                arrayList2.add(new SingleChar(c2));
                continue;
            }
            if (c2 == c - '\u0001') {
                arrayList2.add(new SingleChar(c2));
                arrayList2.add(new SingleChar(c));
                continue;
            }
            arrayList2.add(new CharRange(c2, c));
        }
        return new Subtraction(new Union(arrayList), new Union(arrayList2));
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar('\n');
            }
            case 'r': {
                this.advance();
                return new SingleChar('\r');
            }
            case 't': {
                this.advance();
                return new SingleChar('\t');
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i;
            }
            case 'I': {
                this.advance();
                return ESC_I;
            }
            case 'c': {
                this.advance();
                return ESC_c;
            }
            case 'C': {
                this.advance();
                return ESC_C;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new Complement(this.parseProp());
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.isXPath) {
                    char c = this.curChar;
                    int n = c - 48;
                    this.advance();
                    int n2 = "0123456789".indexOf(this.curChar);
                    if (n2 >= 0) {
                        int n3 = n * 10 + n2;
                        this.advance();
                        if (this.captures.contains(n3)) {
                            return new BackReference(n3);
                        }
                        this.recede();
                    }
                    return new BackReference(n);
                }
                throw this.makeException("digit not allowed after \\");
            }
            case '$': {
                if (this.isXPath) break;
            }
            default: {
                throw this.makeException("invalid escape sequence");
            }
        }
        SingleChar singleChar = new SingleChar(this.curChar);
        this.advance();
        return singleChar;
    }

    private CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int n = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (JDK14RegexTranslator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        String string = ((Object)this.regExp.subSequence(n, this.pos - 1)).toString();
        this.advance();
        switch (string.length()) {
            case 0: {
                throw this.makeException("empty property name");
            }
            case 2: {
                int n2 = subCategories.indexOf(string);
                if (n2 < 0 || n2 % 2 == 1) {
                    throw this.makeException("unknown category");
                }
                return JDK14RegexTranslator.getSubCategoryCharClass(n2 / 2);
            }
            case 1: {
                int n3 = categories.indexOf(string.charAt(0));
                if (n3 < 0) {
                    throw this.makeException("unknown category", string);
                }
                return JDK14RegexTranslator.getCategoryCharClass(n3);
            }
        }
        if (string.startsWith("Is")) {
            String string2 = string.substring(2);
            for (int i = 0; i < specialBlockNames.length; ++i) {
                if (!string2.equals(specialBlockNames[i])) continue;
                return specialBlockCharClasses[i];
            }
            if (!JDK14RegexTranslator.isBlock(string2)) {
                throw this.makeException("invalid block name", string2);
            }
            return new Property("In" + string2);
        }
        throw this.makeException("invalid property name", string);
    }

    private static boolean isBlock(String string) {
        for (int i = 0; i < blockNames.length; ++i) {
            if (!string.equals(blockNames[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isAsciiAlnum(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    private void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        CharClass charClass;
        boolean bl;
        if (this.curChar == '^') {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>(10);
        boolean bl2 = true;
        do {
            charClass = this.parseCharClassEscOrXmlChar(bl2);
            bl2 = false;
            arrayList.add(charClass);
            if (this.curChar != '-') continue;
            this.advance();
            if (this.curChar == ']' || this.curChar == '[') break;
            CharClass charClass2 = this.parseCharClassEscOrXmlChar(bl2);
            if (charClass.getSingleChar() < 0 || charClass2.getSingleChar() < 0) {
                throw this.makeException("multi_range");
            }
            if (charClass.getSingleChar() > charClass2.getSingleChar()) {
                throw this.makeException("invalid range (start > end)");
            }
            arrayList.set(arrayList.size() - 1, new CharRange(charClass.getSingleChar(), charClass2.getSingleChar()));
            if (this.curChar != '-') continue;
            this.advance();
            this.expect('[');
            break;
        } while (this.curChar != ']');
        charClass = arrayList.size() == 1 ? (CharClass)arrayList.get(0) : new Union(arrayList);
        if (bl) {
            charClass = new Complement(charClass);
        }
        if (this.curChar == '[') {
            this.advance();
            charClass = new Subtraction(charClass, this.parseCharClassExpr());
            this.expect(']');
        }
        this.advance();
        return charClass;
    }

    private CharClass parseCharClassEscOrXmlChar(boolean bl) throws RegexSyntaxException {
        SimpleCharClass simpleCharClass;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '[': 
            case ']': {
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
            case '-': {
                if (bl) break;
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
        }
        if (XMLChar.isSurrogate(this.curChar)) {
            if (!XMLChar.isHighSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            char c = this.curChar;
            this.advance();
            if (!XMLChar.isLowSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            simpleCharClass = new WideSingleChar(XMLChar.supplemental(c, this.curChar));
        } else {
            simpleCharClass = new SingleChar(this.curChar);
        }
        this.advance();
        return simpleCharClass;
    }

    private RegexSyntaxException makeException(String string) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression " + Err.wrap(this.regExp, 4) + ": " + string);
    }

    private RegexSyntaxException makeException(String string, String string2) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression " + Err.wrap(this.regExp, 4) + ": " + string + " (" + string2 + ')');
    }

    private static boolean isJavaMetaChar(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static synchronized CharClass getCategoryCharClass(int n) {
        if (categoryCharClasses[n] == null) {
            JDK14RegexTranslator.categoryCharClasses[n] = JDK14RegexTranslator.computeCategoryCharClass(categories.charAt(n));
        }
        return categoryCharClasses[n];
    }

    private static synchronized CharClass getSubCategoryCharClass(int n) {
        if (subCategoryCharClasses[n] == null) {
            JDK14RegexTranslator.subCategoryCharClasses[n] = JDK14RegexTranslator.computeSubCategoryCharClass(subCategories.substring(n * 2, (n + 1) * 2));
        }
        return subCategoryCharClasses[n];
    }

    private static CharClass computeCategoryCharClass(char c) {
        int n;
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>(5);
        arrayList.add(new Property(new String(new char[]{c})));
        int n2 = CATEGORY_NAMES.indexOf(c);
        while (n2 >= 0) {
            int[] nArray = CATEGORY_RANGES[n2 / 2];
            for (n = 0; n < nArray.length; n += 2) {
                arrayList.add(new CharRange(nArray[n], nArray[n + 1]));
            }
            n2 = CATEGORY_NAMES.indexOf(c, n2 + 1);
        }
        if (c == 'P') {
            arrayList.add(JDK14RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (c == 'L') {
            arrayList.add(new SingleChar('\u03f5'));
            arrayList.add(new SingleChar('\u03f4'));
        }
        if (c == 'C') {
            arrayList.add(new Subtraction(new Property("Cn"), new Union(new CharClass[]{new SingleChar('\u03f4'), new SingleChar('\u03f5')})));
            ArrayList<CharRange> arrayList2 = new ArrayList<CharRange>(5);
            for (int i = 0; i < CATEGORY_RANGES.length; ++i) {
                for (n = 0; n < CATEGORY_RANGES[i].length; n += 2) {
                    arrayList2.add(new CharRange(CATEGORY_RANGES[i][n], CATEGORY_RANGES[i][n + 1]));
                }
            }
            arrayList.add(new Subtraction(new CharRange(65536, 0x10FFFF), new Union(arrayList2)));
        }
        if (arrayList.size() == 1) {
            return (CharClass)arrayList.get(0);
        }
        return new Union(arrayList);
    }

    private static CharClass computeSubCategoryCharClass(String string) {
        Property property = new Property(string);
        int n = CATEGORY_NAMES.indexOf(string);
        if (n < 0) {
            if (string.equals("Cn")) {
                ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>(5);
                arrayList.add(new SingleChar('\u03f4'));
                arrayList.add(new SingleChar('\u03f5'));
                for (int i = 0; i < CATEGORY_RANGES.length; ++i) {
                    for (int j = 0; j < CATEGORY_RANGES[i].length; j += 2) {
                        arrayList.add(new CharRange(CATEGORY_RANGES[i][j], CATEGORY_RANGES[i][j + 1]));
                    }
                }
                return new Subtraction(new Union(new CharClass[]{property, new CharRange(65536, 0x10FFFF)}), new Union(arrayList));
            }
            if (string.equals("Pi")) {
                return JDK14RegexTranslator.makeCharClass(CATEGORY_Pi);
            }
            if (string.equals("Pf")) {
                return JDK14RegexTranslator.makeCharClass(CATEGORY_Pf);
            }
            return property;
        }
        ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>(5);
        arrayList.add(property);
        int[] nArray = CATEGORY_RANGES[n / 2];
        for (int i = 0; i < nArray.length; i += 2) {
            arrayList.add(new CharRange(nArray[i], nArray[i + 1]));
        }
        if (string.equals("Lu")) {
            arrayList.add(new SingleChar('\u03f4'));
        } else if (string.equals("Ll")) {
            arrayList.add(new SingleChar('\u03f5'));
        } else if (string.equals("Nl")) {
            arrayList.add(new CharRange(5870, 5872));
        } else if (string.equals("No")) {
            return new Subtraction(new Union(arrayList), new CharRange(5870, 5872));
        }
        return new Union(arrayList);
    }

    private static CharClass makeCharClass(String string) {
        ArrayList<SingleChar> arrayList = new ArrayList<SingleChar>(5);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SingleChar(string.charAt(i)));
        }
        return new Union(arrayList);
    }

    public static void main(String[] stringArray) throws RegexSyntaxException {
        String string = new JDK14RegexTranslator().translate(stringArray[0], stringArray[1].equals("xpath"));
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') {
                System.err.print(c);
                continue;
            }
            System.err.print("\\u");
            for (int j = 12; j >= 0; j -= 4) {
                System.err.print("0123456789ABCDEF".charAt(c >> j & 0xF));
            }
        }
        System.err.println();
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        Complement(CharClass charClass) {
            super(-charClass.getContainsBmp(), -charClass.getContainsNonBmp());
            this.cc = charClass;
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            this.cc.outputComplementBmp(fastStringBuffer);
        }

        void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            this.cc.outputBmp(fastStringBuffer);
        }

        void addNonBmpRanges(List list) {
            ArrayList arrayList = new ArrayList(5);
            this.cc.addNonBmpRanges(arrayList);
            Complement.sortRangeList(arrayList);
            int n = 65536;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Range range = (Range)arrayList.get(i);
                if (range.getMin() > n) {
                    list.add(new Range(n, range.getMin() - 1));
                }
                n = range.getMax() + 1;
            }
            if (n != 0x110000) {
                list.add(new Range(n, 0x10FFFF));
            }
        }
    }

    static class Dot
    extends CharClass {
        Dot() {
            super(0, -1);
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("(?:.|");
            fastStringBuffer.append(JDK14RegexTranslator.SURROGATES1_CLASS);
            fastStringBuffer.append(JDK14RegexTranslator.SURROGATES2_CLASS);
            fastStringBuffer.append(")");
        }

        void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("[^\\n]");
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append(".");
        }
    }

    static class BackReference
    extends CharClass {
        private final int i;

        BackReference(int n) {
            super(0, -1);
            this.i = n;
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\" + this.i + ".{0}");
        }
    }

    static class Union
    extends CharClass {
        private final List members;

        Union(CharClass[] charClassArray) {
            this(Union.toList(charClassArray));
        }

        private static List toList(CharClass[] charClassArray) {
            ArrayList<CharClass> arrayList = new ArrayList<CharClass>(5);
            for (int i = 0; i < charClassArray.length; ++i) {
                arrayList.add(charClassArray[i]);
            }
            return arrayList;
        }

        Union(List list) {
            super(Union.computeContainsBmp(list), Union.computeContainsNonBmp(list));
            this.members = list;
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                CharClass charClass = (CharClass)this.members.get(i);
                if (charClass.getContainsBmp() == -1) continue;
                if (charClass instanceof SimpleCharClass) {
                    ((SimpleCharClass)charClass).inClassOutputBmp(fastStringBuffer);
                    continue;
                }
                charClass.outputBmp(fastStringBuffer);
            }
            fastStringBuffer.append(']');
        }

        void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            CharClass charClass;
            int n;
            boolean bl = true;
            int n2 = this.members.size();
            for (n = 0; n < n2; ++n) {
                charClass = (CharClass)this.members.get(n);
                if (charClass.getContainsBmp() == -1 || !(charClass instanceof SimpleCharClass)) continue;
                if (bl) {
                    fastStringBuffer.append("[^");
                    bl = false;
                }
                ((SimpleCharClass)charClass).inClassOutputBmp(fastStringBuffer);
            }
            for (n = 0; n < n2; ++n) {
                charClass = (CharClass)this.members.get(n);
                if (charClass.getContainsBmp() == -1 || charClass instanceof SimpleCharClass) continue;
                if (bl) {
                    fastStringBuffer.append('[');
                    bl = false;
                } else {
                    fastStringBuffer.append("&&");
                }
                charClass.outputComplementBmp(fastStringBuffer);
            }
            if (bl) {
                fastStringBuffer.append("[\u0000-\uffff]");
            } else {
                fastStringBuffer.append(']');
            }
        }

        void addNonBmpRanges(List list) {
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                ((CharClass)this.members.get(i)).addNonBmpRanges(list);
            }
        }

        private static int computeContainsBmp(List list) {
            int n = -1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = Math.max(n, ((CharClass)list.get(i)).getContainsBmp());
            }
            return n;
        }

        private static int computeContainsNonBmp(List list) {
            int n = -1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = Math.max(n, ((CharClass)list.get(i)).getContainsNonBmp());
            }
            return n;
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass charClass, CharClass charClass2) {
            super(Math.min(charClass.getContainsBmp(), -charClass2.getContainsBmp()), Math.min(charClass.getContainsNonBmp(), -charClass2.getContainsNonBmp()));
            this.cc1 = charClass;
            this.cc2 = charClass2;
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.cc1.outputBmp(fastStringBuffer);
            fastStringBuffer.append("&&");
            this.cc2.outputComplementBmp(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.cc1.outputComplementBmp(fastStringBuffer);
            this.cc2.outputBmp(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        void addNonBmpRanges(List list) {
            ArrayList arrayList = new ArrayList(5);
            this.cc1.addNonBmpRanges(arrayList);
            ArrayList arrayList2 = new ArrayList(5);
            this.cc2.addNonBmpRanges(arrayList2);
            Subtraction.sortRangeList(arrayList);
            Subtraction.sortRangeList(arrayList2);
            Iterator iterator = arrayList2.iterator();
            Range range = iterator.hasNext() ? (Range)iterator.next() : null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Range range2 = (Range)arrayList.get(i);
                while (range != null && range.getMax() < range2.getMin()) {
                    if (iterator.hasNext()) {
                        range = (Range)iterator.next();
                        continue;
                    }
                    range = null;
                }
                int n2 = range2.getMin();
                while (range != null && range.getMin() <= range2.getMax()) {
                    if (n2 < range.getMin()) {
                        list.add(new Range(n2, range.getMin() - 1));
                    }
                    if ((n2 = range.getMax() + 1) > range2.getMax()) break;
                    if (iterator.hasNext()) {
                        range = (Range)iterator.next();
                        continue;
                    }
                    range = null;
                }
                if (n2 > range2.getMax()) continue;
                list.add(new Range(n2, range2.getMax()));
            }
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String string) {
            super(0, -1);
            this.name = string;
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\p{");
            fastStringBuffer.append(this.name);
            fastStringBuffer.append('}');
        }

        void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\P{");
            fastStringBuffer.append(this.name);
            fastStringBuffer.append('}');
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int n, int n2) {
            super(n < 65536 ? 0 : -1, n2 >= 65536 ? 0 : -1);
            this.lower = n;
            this.upper = n2;
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            if (this.lower >= 65536) {
                throw new RuntimeException("BMP output botch");
            }
            if (JDK14RegexTranslator.isJavaMetaChar((char)this.lower)) {
                fastStringBuffer.append('\\');
            }
            fastStringBuffer.append((char)this.lower);
            fastStringBuffer.append('-');
            if (this.upper < 65536) {
                if (JDK14RegexTranslator.isJavaMetaChar((char)this.upper)) {
                    fastStringBuffer.append('\\');
                }
                fastStringBuffer.append((char)this.upper);
            } else {
                fastStringBuffer.append('\uffff');
            }
        }

        void addNonBmpRanges(List list) {
            if (this.upper >= 65536) {
                list.add(new Range(this.lower < 65536 ? 65536 : this.lower, this.upper));
            }
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
            super(-1, -1);
        }

        static Empty getInstance() {
            return instance;
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class WideSingleChar
    extends SimpleCharClass {
        private final int c;

        WideSingleChar(int n) {
            super(-1, 0);
            this.c = n;
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            throw new RuntimeException("BMP output botch");
        }

        int getSingleChar() {
            return this.c;
        }

        void addNonBmpRanges(List list) {
            list.add(new Range(this.c, this.c));
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final char c;

        SingleChar(char c) {
            super(0, -1);
            this.c = c;
        }

        int getSingleChar() {
            return this.c;
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            this.inClassOutputBmp(fastStringBuffer);
        }

        void inClassOutputBmp(FastStringBuffer fastStringBuffer) {
            if (JDK14RegexTranslator.isJavaMetaChar(this.c)) {
                fastStringBuffer.append('\\');
                fastStringBuffer.append(this.c);
            } else {
                switch (this.c) {
                    case '\r': {
                        fastStringBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        fastStringBuffer.append("\\n");
                        break;
                    }
                    case '\t': {
                        fastStringBuffer.append("\\t");
                        break;
                    }
                    case ' ': {
                        fastStringBuffer.append("\\x20");
                        break;
                    }
                    default: {
                        fastStringBuffer.append(this.c);
                    }
                }
            }
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass(int n, int n2) {
            super(n, n2);
        }

        void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.inClassOutputBmp(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            if (this.getContainsBmp() == -1) {
                fastStringBuffer.append("[\u0000-\uffff]");
            } else {
                fastStringBuffer.append("[^");
                this.inClassOutputBmp(fastStringBuffer);
                fastStringBuffer.append(']');
            }
        }

        abstract void inClassOutputBmp(FastStringBuffer var1);
    }

    static abstract class CharClass {
        private final int containsBmp;
        private final int containsNonBmp;

        protected CharClass(int n, int n2) {
            this.containsBmp = n;
            this.containsNonBmp = n2;
        }

        int getContainsBmp() {
            return this.containsBmp;
        }

        int getContainsNonBmp() {
            return this.containsNonBmp;
        }

        final void output(FastStringBuffer fastStringBuffer) {
            switch (this.containsNonBmp) {
                case -1: {
                    if (this.containsBmp == -1) {
                        fastStringBuffer.append(JDK14RegexTranslator.NOT_ALLOWED_CLASS);
                        break;
                    }
                    this.outputBmp(fastStringBuffer);
                    break;
                }
                case 1: {
                    fastStringBuffer.append("(?:");
                    if (this.containsBmp == -1) {
                        fastStringBuffer.append(JDK14RegexTranslator.SURROGATES1_CLASS);
                        fastStringBuffer.append(JDK14RegexTranslator.SURROGATES2_CLASS);
                    } else {
                        this.outputBmp(fastStringBuffer);
                        fastStringBuffer.append(JDK14RegexTranslator.SURROGATES2_CLASS);
                        fastStringBuffer.append('?');
                    }
                    fastStringBuffer.append(')');
                    break;
                }
                case 0: {
                    char c;
                    int n;
                    int n2;
                    fastStringBuffer.append("(?:");
                    boolean bl = false;
                    if (this.containsBmp != -1) {
                        bl = true;
                        this.outputBmp(fastStringBuffer);
                    }
                    ArrayList arrayList = new ArrayList(10);
                    this.addNonBmpRanges(arrayList);
                    CharClass.sortRangeList(arrayList);
                    String string = CharClass.highSurrogateRanges(arrayList);
                    if (string.length() > 0) {
                        if (bl) {
                            fastStringBuffer.append('|');
                        } else {
                            bl = true;
                        }
                        fastStringBuffer.append('[');
                        n2 = string.length();
                        for (int i = 0; i < n2; i += 2) {
                            n = string.charAt(i);
                            if (n == (c = string.charAt(i + 1))) {
                                fastStringBuffer.append((char)n);
                                continue;
                            }
                            fastStringBuffer.append((char)n);
                            fastStringBuffer.append('-');
                            fastStringBuffer.append(c);
                        }
                        fastStringBuffer.append(']');
                        fastStringBuffer.append(JDK14RegexTranslator.SURROGATES2_CLASS);
                    }
                    String string2 = CharClass.lowSurrogateRanges(arrayList);
                    n = string2.length();
                    for (n2 = 0; n2 < n; n2 += 3) {
                        if (bl) {
                            fastStringBuffer.append('|');
                        } else {
                            bl = true;
                        }
                        fastStringBuffer.append(string2.charAt(n2));
                        c = string2.charAt(n2 + 1);
                        char c2 = string2.charAt(n2 + 2);
                        if (c == c2 && (n2 + 3 >= n || string2.charAt(n2 + 3) != string2.charAt(n2))) {
                            fastStringBuffer.append(c);
                            continue;
                        }
                        fastStringBuffer.append('[');
                        while (true) {
                            if (c == c2) {
                                fastStringBuffer.append(c);
                            } else {
                                fastStringBuffer.append(c);
                                fastStringBuffer.append('-');
                                fastStringBuffer.append(c2);
                            }
                            if (n2 + 3 >= n || string2.charAt(n2 + 3) != string2.charAt(n2)) break;
                            c = string2.charAt((n2 += 3) + 1);
                            c2 = string2.charAt(n2 + 2);
                        }
                        fastStringBuffer.append(']');
                    }
                    if (!bl) {
                        fastStringBuffer.append(JDK14RegexTranslator.NOT_ALLOWED_CLASS);
                    }
                    fastStringBuffer.append(')');
                }
            }
        }

        static String highSurrogateRanges(List list) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(list.size() * 2);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Range range = (Range)list.get(i);
                char c = XMLChar.highSurrogate(range.getMin());
                char c2 = XMLChar.lowSurrogate(range.getMin());
                char c3 = XMLChar.highSurrogate(range.getMax());
                char c4 = XMLChar.lowSurrogate(range.getMax());
                if (c2 != '\udc00') {
                    c = (char)(c + '\u0001');
                }
                if (c4 != '\udfff') {
                    c3 = (char)(c3 - '\u0001');
                }
                if (c3 < c) continue;
                fastStringBuffer.append(c);
                fastStringBuffer.append(c3);
            }
            return fastStringBuffer.toString();
        }

        static String lowSurrogateRanges(List list) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(list.size() * 2);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Range range = (Range)list.get(i);
                char c = XMLChar.highSurrogate(range.getMin());
                char c2 = XMLChar.lowSurrogate(range.getMin());
                char c3 = XMLChar.highSurrogate(range.getMax());
                char c4 = XMLChar.lowSurrogate(range.getMax());
                if (c == c3) {
                    if (c2 == '\udc00' && c4 == '\udfff') continue;
                    fastStringBuffer.append(c);
                    fastStringBuffer.append(c2);
                    fastStringBuffer.append(c4);
                    continue;
                }
                if (c2 != '\udc00') {
                    fastStringBuffer.append(c);
                    fastStringBuffer.append(c2);
                    fastStringBuffer.append('\udfff');
                }
                if (c4 == '\udfff') continue;
                fastStringBuffer.append(c3);
                fastStringBuffer.append('\udc00');
                fastStringBuffer.append(c4);
            }
            return fastStringBuffer.toString();
        }

        abstract void outputBmp(FastStringBuffer var1);

        abstract void outputComplementBmp(FastStringBuffer var1);

        int getSingleChar() {
            return -1;
        }

        void addNonBmpRanges(List list) {
        }

        static void sortRangeList(List list) {
            Collections.sort(list);
            int n = 0;
            int n2 = 0;
            int n3 = list.size();
            while (n2 < n3) {
                Range range;
                Range range2 = (Range)list.get(n2);
                int n4 = range2.getMin();
                int n5 = range2.getMax();
                while (++n2 < n3 && (range = (Range)list.get(n2)).getMin() <= n5 + 1) {
                    if (range.getMax() <= n5) continue;
                    n5 = range.getMax();
                }
                if (n5 != range2.getMax()) {
                    range2 = new Range(n4, n5);
                }
                list.set(n++, range2);
            }
            while (n3 > n) {
                list.remove(--n3);
            }
        }
    }

    static final class Range
    implements Comparable {
        private final int min;
        private final int max;

        Range(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        int getMin() {
            return this.min;
        }

        int getMax() {
            return this.max;
        }

        public int compareTo(Object object) {
            Range range = (Range)object;
            if (this.min < range.min) {
                return -1;
            }
            if (this.min > range.min) {
                return 1;
            }
            if (this.max > range.max) {
                return -1;
            }
            if (this.max < range.max) {
                return 1;
            }
            return 0;
        }
    }
}

