/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.Obligation;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Target;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPolicy
implements PolicyTreeElement {
    public static final String XPATH_1_0_VERSION = "http://www.w3.org/TR/1999/Rec-xpath-19991116";
    private URI idAttr;
    private CombiningAlgorithm combiningAlg;
    private String description;
    private Target target;
    private String defaultVersion;
    private List children;
    private Set obligations;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$AbstractPolicy == null ? (class$com$sun$xacml$AbstractPolicy = AbstractPolicy.class$("com.sun.xacml.AbstractPolicy")) : class$com$sun$xacml$AbstractPolicy).getName());
    static /* synthetic */ Class class$com$sun$xacml$AbstractPolicy;

    protected AbstractPolicy() {
    }

    protected AbstractPolicy(URI id, CombiningAlgorithm combiningAlg, String description, Target target) {
        this(id, combiningAlg, description, target, null);
    }

    protected AbstractPolicy(URI id, CombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion) {
        this(id, combiningAlg, description, target, defaultVersion, null);
    }

    protected AbstractPolicy(URI id, CombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, Set obligations) {
        this.idAttr = id;
        this.combiningAlg = combiningAlg;
        this.description = description;
        this.target = target;
        this.defaultVersion = defaultVersion;
        this.obligations = obligations == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(obligations));
    }

    protected AbstractPolicy(Node root, String policyPrefix, String combiningName) throws ParsingException {
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.idAttr = new URI(attrs.getNamedItem(policyPrefix + "Id").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute " + policyPrefix + "Id", e);
        }
        try {
            URI algId = new URI(attrs.getNamedItem(combiningName).getNodeValue());
            CombiningAlgFactory factory = CombiningAlgFactory.getInstance();
            this.combiningAlg = factory.createAlgorithm(algId);
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing combining algorithm in " + policyPrefix, e);
        }
        if (policyPrefix.equals("Policy")) {
            if (!(this.combiningAlg instanceof RuleCombiningAlgorithm)) {
                throw new ParsingException("Policy must use a Rule Combining Algorithm");
            }
        } else if (!(this.combiningAlg instanceof PolicyCombiningAlgorithm)) {
            throw new ParsingException("PolicySet must use a Policy Combining Algorithm");
        }
        this.obligations = new HashSet();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = child.getNodeName();
            if (cname.equals("Description")) {
                this.description = child.getFirstChild().getNodeValue();
                continue;
            }
            if (cname.equals("Target")) {
                this.target = Target.getInstance(child, this.defaultVersion);
                continue;
            }
            if (cname.equals("Obligations")) {
                this.parseObligations(child);
                continue;
            }
            if (!cname.equals(policyPrefix + "Defaults")) continue;
            this.handleDefaults(child);
        }
        this.obligations = Collections.unmodifiableSet(this.obligations);
    }

    private void parseObligations(Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Obligation")) continue;
            this.obligations.add(Obligation.getInstance(node));
        }
    }

    private void handleDefaults(Node root) throws ParsingException {
        this.defaultVersion = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("XPathVersion")) continue;
            this.defaultVersion = node.getFirstChild().getNodeValue();
            if (this.defaultVersion.equals(XPATH_1_0_VERSION)) continue;
            throw new ParsingException("Unknown XPath version");
        }
    }

    public URI getId() {
        return this.idAttr;
    }

    public CombiningAlgorithm getCombiningAlg() {
        return this.combiningAlg;
    }

    public String getDescription() {
        return this.description;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public List getChildren() {
        return this.children;
    }

    public Set getObligations() {
        return this.obligations;
    }

    public MatchResult match(EvaluationCtx context) {
        return this.target.match(context);
    }

    protected void setChildren(List children) {
        this.children = children == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(children);
    }

    public Result evaluate(EvaluationCtx context) {
        Result result = this.combiningAlg.combine(context, this.children);
        if (this.obligations.size() == 0) {
            return result;
        }
        int effect = result.getDecision();
        if (effect == 2 || effect == 3) {
            return result;
        }
        Iterator it = this.obligations.iterator();
        while (it.hasNext()) {
            Obligation obligation = (Obligation)it.next();
            if (obligation.getFulfillOn() != effect) continue;
            result.addObligation(obligation);
        }
        return result;
    }

    protected void encodeCommonElements(OutputStream output, Indenter indenter) {
        this.target.encode(output, indenter);
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            ((PolicyTreeElement)it.next()).encode(output, indenter);
        }
        if (this.obligations.size() != 0) {
            PrintStream out = new PrintStream(output);
            String indent = indenter.makeString();
            out.println(indent + "<Obligations>");
            indenter.in();
            it = this.obligations.iterator();
            while (it.hasNext()) {
                ((Obligation)it.next()).encode(output, indenter);
            }
            out.println(indent + "</Obligations>");
            indenter.out();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

