/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.Result;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Obligation {
    private URI id;
    private int fulfillOn;
    private List assignments;

    public Obligation(URI id, int fulfillOn, List assignments) {
        this.id = id;
        this.fulfillOn = fulfillOn;
        this.assignments = Collections.unmodifiableList(new ArrayList(assignments));
    }

    public static Obligation getInstance(Node root) throws ParsingException {
        URI id;
        int fulfillOn = -1;
        ArrayList<Attribute> assignments = new ArrayList<Attribute>();
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attriubte ObligationId", e);
        }
        String effect = null;
        try {
            effect = attrs.getNamedItem("FulfillOn").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attriubte FulfillOn", e);
        }
        if (effect.equals("Permit")) {
            fulfillOn = 0;
        } else if (effect.equals("Deny")) {
            fulfillOn = 1;
        } else {
            throw new ParsingException("Invlid Effect type: " + effect);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("AttributeAssignment")) continue;
            try {
                URI attrId = new URI(node.getAttributes().getNamedItem("AttributeId").getNodeValue());
                AttributeValue attrValue = attrFactory.createValue(node);
                assignments.add(new Attribute(attrId, null, null, attrValue));
                continue;
            }
            catch (URISyntaxException use) {
                throw new ParsingException("Error parsing URI", use);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeId", uie);
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing attribute assignments", e);
            }
        }
        return new Obligation(id, fulfillOn, assignments);
    }

    public URI getId() {
        return this.id;
    }

    public int getFulfillOn() {
        return this.fulfillOn;
    }

    public List getAssignments() {
        return this.assignments;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Obligation ObligationId=\"" + this.id.toString() + "\" FulfillOn=\"" + Result.DECISIONS[this.fulfillOn] + "\">");
        indenter.in();
        Iterator it = this.assignments.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            out.println(indenter.makeString() + "<AttributeAssignment AttributeId=\"" + attr.getId().toString() + "\" DataType=\"" + attr.getType().toString() + "\">" + attr.getValue().encode() + "</AttributeAssignment>");
        }
        indenter.out();
        out.println(indent + "</Obligation>");
    }
}

