/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.BasicEvaluationCtx;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderResult;
import com.sun.xacml.finder.ResourceFinder;
import com.sun.xacml.finder.ResourceFinderResult;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDP {
    private AttributeFinder attributeFinder;
    private PolicyFinder policyFinder;
    private ResourceFinder resourceFinder;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$PDP == null ? (class$com$sun$xacml$PDP = PDP.class$("com.sun.xacml.PDP")) : class$com$sun$xacml$PDP).getName());
    static /* synthetic */ Class class$com$sun$xacml$PDP;

    public PDP(PDPConfig config) {
        logger.fine("creating a PDP");
        this.attributeFinder = config.getAttributeFinder();
        this.policyFinder = config.getPolicyFinder();
        this.policyFinder.init();
        this.resourceFinder = config.getResourceFinder();
    }

    public ResponseCtx evaluate(RequestCtx request) {
        try {
            return this.evaluate(new BasicEvaluationCtx(request, this.attributeFinder));
        }
        catch (ParsingException pe) {
            logger.log(Level.INFO, "the PDP receieved an invalid request", pe);
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
            Status status = new Status(code, pe.getMessage());
            return new ResponseCtx(new Result(2, status));
        }
    }

    public ResponseCtx evaluate(EvaluationCtx context) {
        if (context.getScope() != 0) {
            AttributeValue parent = context.getResourceId();
            ResourceFinderResult resourceResult = null;
            resourceResult = context.getScope() == 1 ? this.resourceFinder.findChildResources(parent, context) : this.resourceFinder.findDescendantResources(parent, context);
            if (resourceResult.isEmpty()) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                String msg = "Couldn't find any resources to work on.";
                return new ResponseCtx(new Result(2, new Status(code, msg), context.getResourceId().encode()));
            }
            HashSet<Result> results = new HashSet<Result>();
            Iterator<Object> it = resourceResult.getResources().iterator();
            while (it.hasNext()) {
                AttributeValue resource = (AttributeValue)it.next();
                context.setResourceId(resource);
                Result result = this.evaluateContext(context);
                result.setResource(resource.encode());
                results.add(result);
            }
            Map failureMap = resourceResult.getFailures();
            it = failureMap.keySet().iterator();
            while (it.hasNext()) {
                AttributeValue resource = (AttributeValue)it.next();
                Status status = (Status)failureMap.get(resource);
                results.add(new Result(2, status, resource.encode()));
            }
            return new ResponseCtx(results);
        }
        return new ResponseCtx(this.evaluateContext(context));
    }

    private Result evaluateContext(EvaluationCtx context) {
        PolicyFinderResult finderResult = this.policyFinder.findPolicy(context);
        if (finderResult.notApplicable()) {
            return new Result(3, context.getResourceId().encode());
        }
        if (finderResult.indeterminate()) {
            return new Result(2, finderResult.getStatus(), context.getResourceId().encode());
        }
        return finderResult.getPolicy().evaluate(context);
    }

    public OutputStream evaluate(InputStream input) {
        RequestCtx request = null;
        ResponseCtx response = null;
        try {
            request = RequestCtx.getInstance(input);
        }
        catch (Exception pe) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
            Status status = new Status(code, "invalid request: " + pe.getMessage());
            response = new ResponseCtx(new Result(2, status));
        }
        if (response == null) {
            response = this.evaluate(request);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.encode(out, new Indenter());
        return out;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

