/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ProcessingException;
import com.sun.xacml.Target;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderResult;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class PolicyReference
extends AbstractPolicy {
    public static final int POLICY_REFERENCE = 0;
    public static final int POLICYSET_REFERENCE = 1;
    private URI reference;
    private int policyType;
    private PolicyFinder finder;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$PolicyReference == null ? (class$com$sun$xacml$PolicyReference = PolicyReference.class$("com.sun.xacml.PolicyReference")) : class$com$sun$xacml$PolicyReference).getName());
    static /* synthetic */ Class class$com$sun$xacml$PolicyReference;

    public PolicyReference(URI reference, int policyType, PolicyFinder finder) throws IllegalArgumentException {
        if (policyType != 0 && policyType != 1) {
            throw new IllegalArgumentException("Input policyType is not avalid value");
        }
        this.reference = reference;
        this.policyType = policyType;
        this.finder = finder;
    }

    /*
     * WARNING - void declaration
     */
    public static PolicyReference getInstance(Node root, PolicyFinder finder) throws ParsingException {
        void var3_4;
        boolean policyType;
        URI reference = null;
        String name = root.getNodeName();
        if (name.equals("PolicyIdReference")) {
            policyType = false;
        } else if (name.equals("PolicySetIdReference")) {
            policyType = true;
        } else {
            throw new ParsingException("Unknown reference type: " + name);
        }
        try {
            reference = new URI(root.getFirstChild().getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Invalid URI in Reference", e);
        }
        return new PolicyReference(reference, (int)var3_4, finder);
    }

    public URI getId() {
        return this.resolvePolicy().getId();
    }

    public CombiningAlgorithm getCombiningAlg() {
        return this.resolvePolicy().getCombiningAlg();
    }

    public String getDescription() {
        return this.resolvePolicy().getDescription();
    }

    public Target getTarget() {
        return this.resolvePolicy().getTarget();
    }

    public String getDefaultVersion() {
        return this.resolvePolicy().getDefaultVersion();
    }

    public List getChildren() {
        return this.resolvePolicy().getChildren();
    }

    public Set getObligations() {
        return this.resolvePolicy().getObligations();
    }

    public MatchResult match(EvaluationCtx context) {
        try {
            return this.getTarget().match(context);
        }
        catch (ProcessingException pe) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, "couldn't resolve policy ref");
            return new MatchResult(2, status);
        }
    }

    private AbstractPolicy resolvePolicy() {
        if (this.finder == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("PolicyReference with id " + this.reference.toString() + " was queried but was " + "not configured with a PolicyFinder");
            }
            throw new ProcessingException("couldn't find the policy with a null finder");
        }
        PolicyFinderResult pfr = this.finder.findPolicy(this.reference, this.policyType);
        if (pfr.notApplicable()) {
            throw new ProcessingException("couldn't resolve the policy");
        }
        if (pfr.indeterminate()) {
            throw new ProcessingException("error resolving the policy");
        }
        return pfr.getPolicy();
    }

    public Result evaluate(EvaluationCtx context) {
        if (this.finder == null) {
            return new Result(3, context.getResourceId().encode());
        }
        PolicyFinderResult pfr = this.finder.findPolicy(this.reference, this.policyType);
        if (pfr.notApplicable()) {
            return new Result(3, context.getResourceId().encode());
        }
        if (pfr.indeterminate()) {
            return new Result(2, pfr.getStatus(), context.getResourceId().encode());
        }
        return pfr.getPolicy().evaluate(context);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String encoded = indenter.makeString();
        if (this.policyType == 0) {
            out.println(encoded + "<PolicyIdReference>" + this.reference.toString() + "</PolicyIdReference>");
        } else {
            out.println(encoded + "<PolicySetIdReference>" + this.reference.toString() + "</PolicySetIdReference>");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

