/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Target;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.Apply;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule
implements PolicyTreeElement {
    private URI idAttr;
    private int effectAttr;
    private String description = null;
    private Target target = null;
    private Apply condition = null;

    public Rule(URI id, int effect, String description, Target target, Apply condition) {
        this.idAttr = id;
        this.effectAttr = effect;
        this.description = description;
        this.target = target;
        this.condition = condition;
    }

    public static Rule getInstance(Node root, String xpathVersion) throws ParsingException {
        URI id = null;
        Object name = null;
        int effect = 0;
        String description = null;
        Target target = null;
        Apply condition = null;
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("RuleId").getNodeValue());
        }
        catch (URISyntaxException use) {
            throw new ParsingException("Error parsing required attribute RuleId", use);
        }
        String str = attrs.getNamedItem("Effect").getNodeValue();
        if (str.equals("Permit")) {
            effect = 0;
        } else if (str.equals("Deny")) {
            effect = 1;
        } else {
            throw new ParsingException("Invalid Effect: " + effect);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = child.getNodeName();
            if (cname.equals("Description")) {
                description = child.getFirstChild().getNodeValue();
                continue;
            }
            if (cname.equals("Target")) {
                target = Target.getInstance(child, xpathVersion);
                continue;
            }
            if (!cname.equals("Condition")) continue;
            condition = Apply.getConditionInstance(child, xpathVersion);
        }
        return new Rule(id, effect, description, target, condition);
    }

    public int getEffect() {
        return this.effectAttr;
    }

    public URI getId() {
        return this.idAttr;
    }

    public String getDescription() {
        return this.description;
    }

    public Target getTarget() {
        return this.target;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public Apply getCondition() {
        return this.condition;
    }

    public MatchResult match(EvaluationCtx context) {
        if (this.target == null) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, "no target available for matching a rule");
            return new MatchResult(2, status);
        }
        return this.target.match(context);
    }

    public Result evaluate(EvaluationCtx context) {
        if (this.target != null) {
            MatchResult match = this.target.match(context);
            int result = match.getResult();
            if (result == 1) {
                return new Result(3, context.getResourceId().encode());
            }
            if (result == 2) {
                return new Result(2, match.getStatus(), context.getResourceId().encode());
            }
        }
        if (this.condition == null) {
            return new Result(this.effectAttr, context.getResourceId().encode());
        }
        EvaluationResult result = this.condition.evaluate(context);
        if (result.indeterminate()) {
            return new Result(2, result.getStatus(), context.getResourceId().encode());
        }
        BooleanAttribute bool = (BooleanAttribute)result.getAttributeValue();
        if (bool.getValue()) {
            return new Result(this.effectAttr, context.getResourceId().encode());
        }
        return new Result(3, context.getResourceId().encode());
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.print(indent + "<Rule RuleId=\"" + this.idAttr.toString() + "\" Effect=\"" + Result.DECISIONS[this.effectAttr] + "\"");
        if (this.description != null || this.target != null || this.condition != null) {
            out.println(">");
            indenter.in();
            String nextIndent = indenter.makeString();
            if (this.description != null) {
                out.println(nextIndent + "<Description>" + this.description + "</Description>");
            }
            if (this.target != null) {
                this.target.encode(output, indenter);
            }
            if (this.condition != null) {
                this.condition.encode(output, indenter);
            }
            indenter.out();
            out.println(indent + "</Rule>");
        } else {
            out.println("/>");
        }
    }
}

