/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.TargetMatch;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Target {
    private List subjects;
    private List resources;
    private List actions;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$Target == null ? (class$com$sun$xacml$Target = Target.class$("com.sun.xacml.Target")) : class$com$sun$xacml$Target).getName());
    static /* synthetic */ Class class$com$sun$xacml$Target;

    public Target(List subjects, List resources, List actions) {
        this.subjects = subjects == null ? subjects : Collections.unmodifiableList(new ArrayList(subjects));
        this.resources = resources == null ? resources : Collections.unmodifiableList(new ArrayList(resources));
        this.actions = actions == null ? actions : Collections.unmodifiableList(new ArrayList(actions));
    }

    public static Target getInstance(Node root, String xpathVersion) throws ParsingException {
        List subjects = null;
        List resources = null;
        List actions = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("Subjects")) {
                subjects = Target.getAttributes(child, "Subject", xpathVersion);
                continue;
            }
            if (name.equals("Resources")) {
                resources = Target.getAttributes(child, "Resource", xpathVersion);
                continue;
            }
            if (!name.equals("Actions")) continue;
            actions = Target.getAttributes(child, "Action", xpathVersion);
        }
        return new Target(subjects, resources, actions);
    }

    private static List getAttributes(Node root, String prefix, String xpathVersion) throws ParsingException {
        ArrayList<List> matches = new ArrayList<List>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(prefix)) {
                matches.add(Target.getMatches(child, prefix, xpathVersion));
                continue;
            }
            if (!name.equals("Any" + prefix)) continue;
            return null;
        }
        return matches;
    }

    private static List getMatches(Node root, String prefix, String xpathVersion) throws ParsingException {
        ArrayList<TargetMatch> list = new ArrayList<TargetMatch>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (!name.equals(prefix + "Match")) continue;
            list.add(TargetMatch.getInstance(child, prefix, xpathVersion));
        }
        return Collections.unmodifiableList(list);
    }

    public List getSubjects() {
        return this.subjects;
    }

    public List getResources() {
        return this.resources;
    }

    public List getActions() {
        return this.actions;
    }

    public MatchResult match(EvaluationCtx context) {
        MatchResult result;
        if (this.subjects != null && (result = this.checkSet(this.subjects, context)).getResult() != 0) {
            logger.finer("failed to match Subjects section of Target");
            return result;
        }
        if (this.resources != null && (result = this.checkSet(this.resources, context)).getResult() != 0) {
            logger.finer("failed to match Resources section of Target");
            return result;
        }
        if (this.actions != null && (result = this.checkSet(this.actions, context)).getResult() != 0) {
            logger.finer("failed to match Actions section of Target");
            return result;
        }
        return new MatchResult(0);
    }

    private MatchResult checkSet(List matchList, EvaluationCtx context) {
        Iterator it = matchList.iterator();
        boolean allFalse = true;
        Status firstIndeterminateStatus = null;
        while (it.hasNext()) {
            TargetMatch tm;
            List list = (List)it.next();
            Iterator it2 = list.iterator();
            MatchResult result = null;
            while (it2.hasNext() && (result = (tm = (TargetMatch)it2.next()).match(context)).getResult() == 0) {
            }
            if (result.getResult() == 0) {
                return result;
            }
            if (result.getResult() != 2) continue;
            allFalse = false;
            if (firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (allFalse) {
            return new MatchResult(1);
        }
        return new MatchResult(2, firstIndeterminateStatus);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Target>");
        indenter.in();
        this.encodeSection(out, indenter, "Subject", this.subjects);
        this.encodeSection(out, indenter, "Resource", this.resources);
        this.encodeSection(out, indenter, "Action", this.actions);
        indenter.out();
        out.println(indent + "</Target>");
    }

    private void encodeSection(PrintStream output, Indenter indenter, String name, List list) {
        String indent = indenter.makeString();
        output.println(indent + "<" + name + "s>");
        indenter.in();
        String indentNext = indenter.makeString();
        if (list == null) {
            output.println(indentNext + "<Any" + name + "/>");
        } else {
            String nextIndent = indenter.makeString();
            Iterator it = list.iterator();
            indenter.in();
            while (it.hasNext()) {
                List items = (List)it.next();
                output.println(indentNext + "<" + name + ">");
                Iterator matchIterator = items.iterator();
                while (matchIterator.hasNext()) {
                    TargetMatch tm = (TargetMatch)matchIterator.next();
                    tm.encode(output, indenter);
                }
                output.println(indentNext + "</" + name + ">");
            }
            indenter.out();
        }
        indenter.out();
        output.println(indent + "</" + name + "s>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

