/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.SetFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConditionSetFunction
extends SetFunction {
    private static final int ID_BASE_AT_LEAST_ONE_MEMBER_OF = 0;
    private static final int ID_BASE_SUBSET = 1;
    private static final int ID_BASE_SET_EQUALS = 2;
    private static HashMap idMap = new HashMap();
    private static HashMap typeMap = new HashMap();
    private static Set supportedIds;

    public ConditionSetFunction(String functionName) {
        super(functionName, ConditionSetFunction.getId(functionName), ConditionSetFunction.getArgumentType(functionName), "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    public ConditionSetFunction(String functionName, String datatype, String functionType) {
        super(functionName, ConditionSetFunction.getId(functionName), datatype, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        Integer id = (Integer)idMap.get(functionName);
        if (id == null) {
            throw new IllegalArgumentException("unknown set function " + functionName);
        }
        return id;
    }

    private static String getArgumentType(String functionName) {
        return (String)typeMap.get(functionName);
    }

    public static Set getSupportedIdentifiers() {
        return supportedIds;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult evalResult = this.evalArgs(inputs, context, argValues);
        if (evalResult != null) {
            return evalResult;
        }
        BagAttribute[] bags = new BagAttribute[]{(BagAttribute)argValues[0], (BagAttribute)argValues[1]};
        BooleanAttribute result = null;
        block0 : switch (this.getFunctionId()) {
            case 0: {
                result = BooleanAttribute.getFalseInstance();
                Iterator it = bags[0].iterator();
                while (it.hasNext()) {
                    if (!bags[1].contains((AttributeValue)it.next())) continue;
                    result = BooleanAttribute.getTrueInstance();
                    break block0;
                }
                break;
            }
            case 1: {
                boolean subset = bags[1].containsAll(bags[0]);
                result = BooleanAttribute.getInstance(subset);
                break;
            }
            case 2: {
                boolean equals = bags[1].containsAll(bags[0]) && bags[0].containsAll(bags[1]);
                result = BooleanAttribute.getInstance(equals);
            }
        }
        return new EvaluationResult(result);
    }

    static {
        for (int i = 0; i < baseTypes.length; ++i) {
            String baseName = "urn:oasis:names:tc:xacml:1.0:function:" + simpleTypes[i];
            String baseType = baseTypes[i];
            idMap.put(baseName + "-at-least-one-member-of", new Integer(0));
            idMap.put(baseName + "-subset", new Integer(1));
            idMap.put(baseName + "-set-equals", new Integer(2));
            typeMap.put(baseName + "-at-least-one-member-of", baseType);
            typeMap.put(baseName + "-subset", baseType);
            typeMap.put(baseName + "-set-equals", baseType);
        }
        supportedIds = Collections.unmodifiableSet(new HashSet(idMap.keySet()));
        idMap.put("-at-least-one-member-of", new Integer(0));
        idMap.put("-subset", new Integer(1));
        idMap.put("-set-equals", new Integer(2));
    }
}

