/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import com.sun.xacml.ctx.Status;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MapFunction
implements Function {
    public static final String NAME_MAP = "urn:oasis:names:tc:xacml:1.0:function:map";
    private URI returnType;
    private static URI identifier;
    private static RuntimeException earlyException;

    public MapFunction(URI returnType) {
        this.returnType = returnType;
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_MAP);
        return set;
    }

    public static MapFunction getInstance(Node root) throws ParsingException {
        URI returnType = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Function")) continue;
            String funcName = node.getAttributes().getNamedItem("FunctionId").getNodeValue();
            FunctionFactory factory = FunctionFactory.getGeneralInstance();
            try {
                Function function = factory.createFunction(funcName);
                returnType = function.getReturnType();
                break;
            }
            catch (FunctionTypeException fte) {
                try {
                    Function function = factory.createAbstractFunction(funcName, root);
                    returnType = function.getReturnType();
                    break;
                }
                catch (Exception e) {
                    throw new ParsingException("invalid abstract map", e);
                }
            }
            catch (Exception e) {
                throw new ParsingException("couldn't parse map body", e);
            }
        }
        if (returnType == null) {
            throw new ParsingException("couldn't find the return type");
        }
        return new MapFunction(returnType);
    }

    public URI getIdentifier() {
        if (earlyException != null) {
            throw earlyException;
        }
        return identifier;
    }

    public URI getReturnType() {
        return this.returnType;
    }

    public boolean returnsBag() {
        return true;
    }

    private static EvaluationResult makeProcessingError(String message) {
        ArrayList<String> code = new ArrayList<String>();
        code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        return new EvaluationResult(new Status(code, message));
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        Iterator iterator = inputs.iterator();
        Function function = (Function)iterator.next();
        BagAttribute bag = (BagAttribute)iterator.next();
        Iterator it = bag.iterator();
        ArrayList<AttributeValue> outputs = new ArrayList<AttributeValue>();
        while (it.hasNext()) {
            ArrayList params = new ArrayList();
            params.add(it.next());
            EvaluationResult result = function.evaluate(params, context);
            if (result.indeterminate()) {
                return result;
            }
            outputs.add(result.getAttributeValue());
        }
        return new EvaluationResult(new BagAttribute(this.returnType, outputs));
    }

    public void checkInputs(List inputs) throws IllegalArgumentException {
        Object[] list = inputs.toArray();
        if (list.length != 2) {
            throw new IllegalArgumentException("map requires two inputs");
        }
        if (!(list[0] instanceof Function)) {
            throw new IllegalArgumentException("first argument to map must be a Function");
        }
        Evaluatable eval = (Evaluatable)list[1];
        if (!eval.evaluatesToBag()) {
            throw new IllegalArgumentException("second argument to map must be a bag");
        }
        ArrayList<Object> input = new ArrayList<Object>();
        input.add(list[1]);
        ((Function)list[0]).checkInputsNoBag(input);
    }

    public void checkInputsNoBag(List inputs) throws IllegalArgumentException {
        throw new IllegalArgumentException("map requires a bag");
    }

    static {
        try {
            identifier = new URI(NAME_MAP);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }
}

