/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.RFC822NameAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.X500NameAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public class MatchFunction
extends FunctionBase {
    public static final String NAME_REGEXP_STRING_MATCH = "urn:oasis:names:tc:xacml:1.0:function:regexp-string-match";
    public static final String NAME_X500NAME_MATCH = "urn:oasis:names:tc:xacml:1.0:function:x500Name-match";
    public static final String NAME_RFC822NAME_MATCH = "urn:oasis:names:tc:xacml:1.0:function:rfc822Name-match";
    private static final int ID_REGEXP_STRING_MATCH = 0;
    private static final int ID_X500NAME_MATCH = 1;
    private static final int ID_RFC822NAME_MATCH = 2;
    private static final String[] regexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#string"};
    private static final String[] x500Params = new String[]{"urn:oasis:names:tc:xacml:1.0:data-type:x500Name", "urn:oasis:names:tc:xacml:1.0:data-type:x500Name"};
    private static final String[] rfc822Params = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name"};
    private static final boolean[] bagParams = new boolean[]{false, false};

    public MatchFunction(String functionName) {
        super(functionName, MatchFunction.getId(functionName), MatchFunction.getArgumentTypes(functionName), bagParams, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_REGEXP_STRING_MATCH)) {
            return 0;
        }
        if (functionName.equals(NAME_X500NAME_MATCH)) {
            return 1;
        }
        if (functionName.equals(NAME_RFC822NAME_MATCH)) {
            return 2;
        }
        throw new IllegalArgumentException("unknown match function: " + functionName);
    }

    private static String[] getArgumentTypes(String functionName) {
        if (functionName.equals(NAME_REGEXP_STRING_MATCH)) {
            return regexpParams;
        }
        if (functionName.equals(NAME_X500NAME_MATCH)) {
            return x500Params;
        }
        return rfc822Params;
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_REGEXP_STRING_MATCH);
        set.add(NAME_X500NAME_MATCH);
        set.add(NAME_RFC822NAME_MATCH);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        boolean boolResult = false;
        switch (this.getFunctionId()) {
            case 0: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((StringAttribute)argValues[1]).getValue();
                StringBuffer buf = new StringBuffer(arg0);
                if (arg0.charAt(0) != '^') {
                    buf = buf.insert(0, ".*");
                }
                if (arg0.charAt(arg0.length() - 1) != '$') {
                    buf = buf.insert(buf.length(), ".*");
                }
                int idx = -1;
                idx = buf.indexOf("\\p{Is", 0);
                while (idx != -1) {
                    buf = buf.replace(idx, idx + 5, "\\p{In");
                    idx = buf.indexOf("\\p{Is", idx);
                }
                idx = -1;
                idx = buf.indexOf("\\P{Is", 0);
                while (idx != -1) {
                    buf = buf.replace(idx, idx + 5, "\\P{In");
                    idx = buf.indexOf("\\P{Is", idx);
                }
                idx = -1;
                idx = buf.indexOf("-[", 0);
                while (idx != -1) {
                    buf = buf.replace(idx, idx + 2, "&&[^");
                    idx = buf.indexOf("-[", idx);
                }
                arg0 = buf.toString();
                boolResult = Pattern.matches(arg0, arg1);
                break;
            }
            case 1: {
                X500Principal arg0 = ((X500NameAttribute)argValues[0]).getValue();
                X500Principal arg1 = ((X500NameAttribute)argValues[1]).getValue();
                boolResult = arg1.getName("CANONICAL").endsWith(arg0.getName("CANONICAL"));
                break;
            }
            case 2: {
                String arg0 = ((StringAttribute)argValues[0]).getValue();
                String arg1 = ((RFC822NameAttribute)argValues[1]).getValue();
                if (arg0.indexOf(64) != -1) {
                    String normalized = new RFC822NameAttribute(arg0).getValue();
                    boolResult = normalized.equals(arg1);
                    break;
                }
                if (arg0.charAt(0) == '.') {
                    boolResult = arg1.endsWith(arg0.toLowerCase());
                    break;
                }
                String mailDomain = arg1.substring(arg1.indexOf(64) + 1);
                boolResult = arg0.toLowerCase().equals(mailDomain);
                break;
            }
        }
        return EvaluationResult.getInstance(boolResult);
    }
}

