/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringNormalizeFunction
extends FunctionBase {
    public static final String NAME_STRING_NORMALIZE_SPACE = "urn:oasis:names:tc:xacml:1.0:function:string-normalize-space";
    public static final String NAME_STRING_NORMALIZE_TO_LOWER_CASE = "urn:oasis:names:tc:xacml:1.0:function:string-normalize-to-lower-case";
    private static final int ID_STRING_NORMALIZE_SPACE = 0;
    private static final int ID_STRING_NORMALIZE_TO_LOWER_CASE = 1;

    public StringNormalizeFunction(String functionName) {
        super(functionName, StringNormalizeFunction.getId(functionName), "http://www.w3.org/2001/XMLSchema#string", false, 1, "http://www.w3.org/2001/XMLSchema#string", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_STRING_NORMALIZE_SPACE)) {
            return 0;
        }
        if (functionName.equals(NAME_STRING_NORMALIZE_TO_LOWER_CASE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown normalize function " + functionName);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_STRING_NORMALIZE_SPACE);
        set.add(NAME_STRING_NORMALIZE_TO_LOWER_CASE);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                int startIndex;
                String str = ((StringAttribute)argValues[0]).getValue();
                int endIndex = str.length() - 1;
                for (startIndex = 0; startIndex <= endIndex && Character.isWhitespace(str.charAt(startIndex)); ++startIndex) {
                }
                while (startIndex <= endIndex && Character.isWhitespace(str.charAt(endIndex))) {
                    --endIndex;
                }
                String strResult = str.substring(startIndex, endIndex + 1);
                result = new EvaluationResult(new StringAttribute(strResult));
                break;
            }
            case 1: {
                String str = ((StringAttribute)argValues[0]).getValue();
                String strResult = str.toLowerCase();
                result = new EvaluationResult(new StringAttribute(strResult));
                break;
            }
        }
        return result;
    }
}

