/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.ws.security.message.token.SignatureConfirmation;
import org.apache.ws.security.message.token.Timestamp;
import org.opensaml.SAMLAssertion;

public class WSSecurityEngineResult {
    private int action;
    private Principal principal;
    private X509Certificate cert;
    private SAMLAssertion assertion;
    private Timestamp timestamp;
    private Set signedElements;
    private byte[] signatureValue = null;
    private SignatureConfirmation sigConf = null;

    public WSSecurityEngineResult(int act, SAMLAssertion ass) {
        this.principal = null;
        this.cert = null;
        this.action = act;
        this.assertion = ass;
    }

    public WSSecurityEngineResult(int act, Principal princ, X509Certificate certificate, Set elements, byte[] sv) {
        this.principal = princ;
        this.action = act;
        this.cert = certificate;
        this.signedElements = elements;
        this.signatureValue = sv;
    }

    public WSSecurityEngineResult(int act, Timestamp tstamp) {
        this.action = act;
        this.timestamp = tstamp;
    }

    public WSSecurityEngineResult(int act, SignatureConfirmation sc) {
        this.action = act;
        this.sigConf = sc;
    }

    public int getAction() {
        return this.action;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public SAMLAssertion getAssertion() {
        return this.assertion;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Set getSignedElements() {
        return this.signedElements;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    public SignatureConfirmation getSigConf() {
        return this.sigConf;
    }

    public void setSignatureValue(byte[] signatureValue) {
        this.signatureValue = signatureValue;
    }
}

