/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.UUIDGenerator;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SecurityContextToken {
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");
    protected Element element = null;
    protected Element elementIdentifier = null;

    public SecurityContextToken(Document doc) {
        this.element = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:SecurityContextToken");
        WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.elementIdentifier = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Identifier");
        this.element.appendChild(this.elementIdentifier);
        String uuid = UUIDGenerator.getUUID();
        this.elementIdentifier.appendChild(doc.createTextNode(uuid));
        this.setID("sctId-" + this.element.hashCode());
    }

    public SecurityContextToken(Document doc, String uuid) {
        this.element = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:SecurityContextToken");
        WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.elementIdentifier = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Identifier");
        this.element.appendChild(this.elementIdentifier);
        this.elementIdentifier.appendChild(doc.createTextNode(uuid));
    }

    public SecurityContextToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.elementIdentifier = (Element)WSSecurityUtil.getDirectChild(this.element, "Identifier", "http://schemas.xmlsoap.org/ws/2005/02/sc");
    }

    public void setIdentifier(Document doc, String uuid) {
        Text node = this.getFirstNode(this.elementIdentifier);
        node.setData(uuid);
    }

    public String getIdentifier() {
        if (this.elementIdentifier != null) {
            return this.getFirstNode(this.elementIdentifier).getData();
        }
        return null;
    }

    public void setElement(Element elem) {
        this.element.appendChild(elem);
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }
}

