/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.model;

import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.PolicyEngineData;

public class AlgorithmSuite
extends PolicyEngineData {
    private String symmetricSignature = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private String asymmetricSignature = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String computedKey = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
    private int maximumSymmetricKeyLength = 256;
    private int minimumAsymmetricKeyLength = 1024;
    private int maximumAsymmetricKeyLength = 4096;
    private String digest;
    private String encryption;
    private String symmetricKeyWrap;
    private String asymmetricKeyWrap;
    private String encryptionKeyDerivation;
    private String signatureKeyDerivation;
    private int minimumSymmetricKeyLength;
    private String c14n = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String soapNormalization;
    private String strTransform;
    private String xPath;

    public void setAlgorithmSuite(String algoSuite) throws WSSPolicyException {
        if ("Basic256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDes".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDesRsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic256Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDesSha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic256Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDesSha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.minimumSymmetricKeyLength = 192;
        } else {
            throw new WSSPolicyException("Invalid algorithm suite : " + algoSuite);
        }
    }

    public String getAsymmetricKeyWrap() {
        return this.asymmetricKeyWrap;
    }

    public String getAsymmetricSignature() {
        return this.asymmetricSignature;
    }

    public String getComputedKey() {
        return this.computedKey;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public String getEncryptionKeyDerivation() {
        return this.encryptionKeyDerivation;
    }

    public int getMaximumAsymmetricKeyLength() {
        return this.maximumAsymmetricKeyLength;
    }

    public int getMaximumSymmetricKeyLength() {
        return this.maximumSymmetricKeyLength;
    }

    public int getMinimumAsymmetricKeyLength() {
        return this.minimumAsymmetricKeyLength;
    }

    public int getMinimumSymmetricKeyLength() {
        return this.minimumSymmetricKeyLength;
    }

    public String getSignatureKeyDerivation() {
        return this.signatureKeyDerivation;
    }

    public String getSymmetricKeyWrap() {
        return this.symmetricKeyWrap;
    }

    public String getSymmetricSignature() {
        return this.symmetricSignature;
    }

    public String getInclusiveC14n() {
        return this.c14n;
    }

    public void setC14n(String c14n) throws WSSPolicyException {
        this.c14n = c14n;
    }

    public String getSoapNormalization() {
        return this.soapNormalization;
    }

    public void setSoapNormalization(String soapNormalization) throws WSSPolicyException {
        this.soapNormalization = soapNormalization;
    }

    public String getStrTransform() {
        return this.strTransform;
    }

    public void setStrTransform(String strTransform) throws WSSPolicyException {
        this.strTransform = strTransform;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setXPath(String path) throws WSSPolicyException {
        this.xPath = path;
    }
}

