/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyReader;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.RootPolicyEngineData;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.AsymmetricBindingProcessor;
import org.apache.ws.security.policy.parser.processors.EncryptedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.EndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SignedEndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SignedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.SignedSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SymmetricBindingProcessor;
import org.apache.ws.security.policy.parser.processors.Wss10Processor;
import org.apache.ws.security.policy.parser.processors.Wss11Processor;

public class WSSPolicyProcessor {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$ws$security$policy$parser$WSSPolicyProcessor == null ? (class$org$apache$ws$security$policy$parser$WSSPolicyProcessor = WSSPolicyProcessor.class$("org.apache.ws.security.policy.parser.WSSPolicyProcessor")) : class$org$apache$ws$security$policy$parser$WSSPolicyProcessor));
    FileInputStream fis = null;
    PolicyReader prdr = null;
    Policy merged = null;
    SecurityPolicyToken topLevel = new SecurityPolicyToken("_TopLevel_", 1, null);
    public SecurityProcessorContext secProcessorContext = null;
    static /* synthetic */ Class class$org$apache$ws$security$policy$parser$WSSPolicyProcessor;

    public boolean setup() throws NoSuchMethodException {
        this.prdr = PolicyFactory.getPolicyReader((int)3);
        SecurityPolicyToken spt = null;
        SignedPartsElementsProcessor spep = new SignedPartsElementsProcessor();
        spt = SecurityPolicy.signedParts.copy();
        spt.setProcessTokenMethod(spep);
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.signedElements.copy();
        spt.setProcessTokenMethod(spep);
        this.topLevel.setChildToken(spt);
        EncryptedPartsElementsProcessor epep = new EncryptedPartsElementsProcessor();
        spt = SecurityPolicy.encryptedParts.copy();
        spt.setProcessTokenMethod(epep);
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.encryptedElements.copy();
        spt.setProcessTokenMethod(epep);
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.asymmetricBinding.copy();
        spt.setProcessTokenMethod(new AsymmetricBindingProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.symmetricBinding.copy();
        spt.setProcessTokenMethod(new SymmetricBindingProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.wss10.copy();
        spt.setProcessTokenMethod(new Wss10Processor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.wss11.copy();
        spt.setProcessTokenMethod(new Wss11Processor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.supportingTokens.copy();
        spt.setProcessTokenMethod(new SupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.signedSupportingTokens.copy();
        spt.setProcessTokenMethod(new SignedSupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.endorsingSupportingTokens.copy();
        spt.setProcessTokenMethod(new EndorsingSupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.signedEndorsingSupportingTokens.copy();
        spt.setProcessTokenMethod(new SignedEndorsingSupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        RootPolicyEngineData ped = new RootPolicyEngineData();
        ped.initializeWithDefaults();
        this.secProcessorContext = new SecurityProcessorContext();
        this.secProcessorContext.pushSecurityToken(this.topLevel);
        this.secProcessorContext.pushPolicyEngineData(ped);
        return true;
    }

    public boolean go(String[] args) {
        this.merged = null;
        for (int i = 0; i < args.length; ++i) {
            try {
                this.fis = new FileInputStream(args[i]);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            Policy newPolicy = this.prdr.readPolicy((InputStream)this.fis);
            newPolicy = (Policy)newPolicy.normalize();
            this.merged = this.merged == null ? newPolicy : (Policy)this.merged.merge((Assertion)newPolicy);
            try {
                this.fis.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.processPolicy(this.merged)) {
            log.debug((Object)"Security Policy sucessfully parsed");
            return true;
        }
        log.debug((Object)"Security Policy not sucessfully parsed");
        return false;
    }

    public boolean processPolicy(Policy policy) {
        if (!policy.isNormalized()) {
            throw new RuntimeException("Policy is not in normalized format");
        }
        XorCompositeAssertion xor = (XorCompositeAssertion)policy.getTerms().get(0);
        List listOfPolicyAlternatives = xor.getTerms();
        boolean success = false;
        int numberOfAlternatives = listOfPolicyAlternatives.size();
        for (int i = 0; !success && i < numberOfAlternatives; ++i) {
            AndCompositeAssertion aPolicyAlternative = (AndCompositeAssertion)listOfPolicyAlternatives.get(i);
            List listOfAssertions = aPolicyAlternative.getTerms();
            Iterator iterator = listOfAssertions.iterator();
            boolean all = true;
            while (all && iterator.hasNext()) {
                Assertion assertion = (Assertion)iterator.next();
                if (!(assertion instanceof PrimitiveAssertion)) {
                    log.debug((Object)("Got a unexpected assertion type: " + assertion.getClass().getName()));
                    continue;
                }
                PrimitiveAssertion pa = (PrimitiveAssertion)assertion;
                if (!pa.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy")) {
                    log.debug((Object)("Got a unexpected assertion: " + pa.getName().getLocalPart()));
                    continue;
                }
                all = this.processPrimitiveAssertion((PrimitiveAssertion)assertion);
            }
            success = all;
        }
        return success;
    }

    boolean processPrimitiveAssertion(PrimitiveAssertion pa) {
        boolean commit = true;
        commit = this.startPolicyTransaction(pa);
        List terms = pa.getTerms();
        if (commit && terms.size() > 0) {
            for (int i = 0; commit && i < terms.size(); ++i) {
                Assertion assertion = (Assertion)pa.getTerms().get(i);
                if (assertion instanceof Policy) {
                    commit = this.processPolicy((Policy)assertion);
                    continue;
                }
                if (!(assertion instanceof PrimitiveAssertion)) continue;
                commit = this.processPrimitiveAssertion((PrimitiveAssertion)assertion);
            }
        }
        if (commit) {
            this.commitPolicyTransaction(pa);
        } else {
            this.abortPolicyTransaction(pa);
        }
        return commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startPolicyTransaction(PrimitiveAssertion pa) {
        String tokenName = pa.getName().getLocalPart();
        SecurityPolicyToken spt = null;
        SecurityPolicyToken currentToken = this.secProcessorContext.readCurrentSecurityToken();
        if (currentToken == null) {
            log.error((Object)"Internal error on token stack - No current token");
            System.exit(1);
        }
        spt = currentToken.getChildToken(tokenName);
        this.secProcessorContext.pushSecurityToken(spt);
        this.secProcessorContext.setAssertion(pa);
        this.secProcessorContext.setAction(1);
        boolean ret = false;
        try {
            if (spt == null) {
                log.error((Object)("Security token: '" + tokenName + "' unknown in context of '" + currentToken.getTokenName()));
                boolean bl = false;
                return bl;
            }
            if (spt.getTokenType() == 1 && this.secProcessorContext.getAction() == 1) {
                this.secProcessorContext.pushPolicyEngineData(PolicyEngineData.copy(pa.getName()));
            }
            ret = spt.invokeProcessTokenMethod(this.secProcessorContext);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (WSSPolicyException e) {
            e.printStackTrace();
        }
        finally {
            this.secProcessorContext.setAction(0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abortPolicyTransaction(PrimitiveAssertion pa) {
        SecurityPolicyToken currentToken = this.secProcessorContext.readCurrentSecurityToken();
        if (currentToken == null) {
            this.secProcessorContext.popSecurityToken();
            log.error((Object)("Abort transaction because of unknown token: '" + pa.getName().getLocalPart() + "'"));
            return;
        }
        this.secProcessorContext.setAssertion(pa);
        this.secProcessorContext.setAction(3);
        try {
            try {
                currentToken.invokeProcessTokenMethod(this.secProcessorContext);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                Object var5_4 = null;
                this.secProcessorContext.setAction(0);
                this.secProcessorContext.popSecurityToken();
                if (currentToken.getTokenType() != 1) return;
                this.secProcessorContext.popPolicyEngineData();
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Object var5_5 = null;
                this.secProcessorContext.setAction(0);
                this.secProcessorContext.popSecurityToken();
                if (currentToken.getTokenType() != 1) return;
                this.secProcessorContext.popPolicyEngineData();
                return;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Object var5_6 = null;
                this.secProcessorContext.setAction(0);
                this.secProcessorContext.popSecurityToken();
                if (currentToken.getTokenType() != 1) return;
                this.secProcessorContext.popPolicyEngineData();
                return;
            }
            Object var5_3 = null;
            this.secProcessorContext.setAction(0);
            this.secProcessorContext.popSecurityToken();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.secProcessorContext.setAction(0);
            this.secProcessorContext.popSecurityToken();
            if (currentToken.getTokenType() != 1) throw throwable;
            this.secProcessorContext.popPolicyEngineData();
            throw throwable;
        }
        if (currentToken.getTokenType() != 1) return;
        this.secProcessorContext.popPolicyEngineData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitPolicyTransaction(PrimitiveAssertion pa) {
        SecurityPolicyToken currentToken = this.secProcessorContext.readCurrentSecurityToken();
        if (currentToken == null) {
            log.error((Object)("Internal error on token stack - Commiting an unknown token: " + pa.getName().getLocalPart() + "'"));
            System.exit(1);
        }
        this.secProcessorContext.setAssertion(pa);
        this.secProcessorContext.setAction(2);
        try {
            try {
                currentToken.invokeProcessTokenMethod(this.secProcessorContext);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                Object var5_4 = null;
                this.secProcessorContext.setAction(0);
                this.secProcessorContext.popSecurityToken();
                if (currentToken.getTokenType() != 1) return;
                this.secProcessorContext.commitPolicyEngineData();
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Object var5_5 = null;
                this.secProcessorContext.setAction(0);
                this.secProcessorContext.popSecurityToken();
                if (currentToken.getTokenType() != 1) return;
                this.secProcessorContext.commitPolicyEngineData();
                return;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Object var5_6 = null;
                this.secProcessorContext.setAction(0);
                this.secProcessorContext.popSecurityToken();
                if (currentToken.getTokenType() != 1) return;
                this.secProcessorContext.commitPolicyEngineData();
                return;
            }
            Object var5_3 = null;
            this.secProcessorContext.setAction(0);
            this.secProcessorContext.popSecurityToken();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.secProcessorContext.setAction(0);
            this.secProcessorContext.popSecurityToken();
            if (currentToken.getTokenType() != 1) throw throwable;
            this.secProcessorContext.commitPolicyEngineData();
            throw throwable;
        }
        if (currentToken.getTokenType() != 1) return;
        this.secProcessorContext.commitPolicyEngineData();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

