/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FormatDateTimeFunction
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("format-dateTime", "http://exist-db.org/xquery/datetime", "datetime"), "Returns a xs:string of the xs:dateTime in $a formatted according to the specification in $b", new SequenceType[]{new SequenceType(50, 2), new SequenceType(22, 2)}, new SequenceType(22, 2));

    public FormatDateTimeFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DateTimeValue dt = (DateTimeValue)args[0].itemAt(0);
        String dateTimeFormat = args[1].itemAt(0).toString();
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
        GregorianCalendar cal = dt.calendar.toGregorianCalendar();
        String formattedDate = sdf.format(cal.getTime());
        return new StringValue(formattedDate);
    }
}

