/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.exist.dom.QName;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.XMLWriter;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.httpclient.BaseHTTPClientFunction;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.ContentHandler;

public class PUTFunction
extends BaseHTTPClientFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("put", "http://exist-db.org/xquery/httpclient", "httpclient"), "Performs a HTTP PUT request. $a is the URL, $b is the XML PUT payload/content, $c determines if cookies persist for the query lifetime. $d defines any HTTP Request Headers to set in the form <headers><header name=\"\" value=\"\"/></headers>. This method returns the HTTP response encoded as an XML fragment, that looks as follows: <httpclient:response xmlns:httpclient=\"http://exist-db.org/xquery/httpclient\" statusCode=\"200\"><httpclient:headers><httpclient:header name=\"name\" value=\"value\"/>...</httpclient:headers><httpclient:body type=\"xml|xhtml|text|binary\" mimetype=\"returned content mimetype\">body content</httpclient:body></httpclient:response> where XML body content will be returned as a Node, HTML body content will be tidied into an XML compatible form, a body with mime-type of \"text/...\" will be returned as a URLEncoded string, and any other body content will be returned as xs:base64Binary encoded data.", new SequenceType[]{new SequenceType(25, 2), new SequenceType(-1, 2), new SequenceType(23, 2), new SequenceType(1, 3)}, new SequenceType(11, 2));

    public PUTFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence response = null;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String url = args[0].itemAt(0).getStringValue();
        Item payload = args[1].itemAt(0);
        boolean persistCookies = args[2].effectiveBooleanValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(baos);
        XMLWriter xmlWriter = new XMLWriter((Writer)osw);
        SAXSerializer sax = new SAXSerializer();
        sax.setReceiver(xmlWriter);
        try {
            payload.toSAX(this.context.getBroker(), (ContentHandler)sax, new Properties());
            osw.flush();
            osw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PutMethod put = new PutMethod(url);
        ByteArrayRequestEntity entity = new ByteArrayRequestEntity(baos.toByteArray(), "text/xml; utf-8");
        put.setRequestEntity((RequestEntity)entity);
        if (!args[3].isEmpty()) {
            this.setHeaders((HttpMethod)put, ((NodeValue)args[3].itemAt(0)).getNode());
        }
        try {
            response = this.doRequest(this.context, (HttpMethod)put, persistCookies);
        }
        catch (IOException ioe) {
            throw new XPathException((Throwable)ioe);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }
}

