/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.exist.dom.QName;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.util.serializer.DOMStreamer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.image.ImageModule;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GetMetadataFunction
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-metadata", "http://exist-db.org/xquery/image", "image"), "Get's the metadta of the image passed in $a, returning the images XML metadata. When $b is true() metadata of the images native format is returned, otherwise common java ImageIO metadata is returned.", new SequenceType[]{new SequenceType(26, 2), new SequenceType(23, 2)}, new SequenceType(-1, 3));

    public GetMetadataFunction(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) return Sequence.EMPTY_SEQUENCE;
        if (args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        byte[] imgData = ImageModule.getImageData((Base64Binary)args[0].itemAt(0));
        boolean nativeFormat = args[1].effectiveBooleanValue();
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(imgData));
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) return Sequence.EMPTY_SEQUENCE;
            ImageReader imageReader = readers.next();
            imageReader.setInput(iis);
            IIOMetadata metadata = imageReader.getImageMetadata(0);
            Node nMetadata = null;
            nMetadata = nativeFormat ? metadata.getAsTree(metadata.getNativeMetadataFormatName()) : metadata.getAsTree("javax_imageio_1.0");
            if (nMetadata == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            this.context.pushDocumentContext();
            try {
                MemTreeBuilder builder = this.context.getDocumentBuilder();
                DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
                DOMStreamer streamer = new DOMStreamer();
                streamer.setContentHandler((ContentHandler)receiver);
                streamer.serialize(nMetadata);
                Document docMetadata = receiver.getDocument();
                NodeValue nodeValue = (NodeValue)docMetadata;
                return nodeValue;
            }
            catch (SAXException se) {
                throw new XPathException((Throwable)se);
            }
            finally {
                this.context.popDocumentContext();
            }
        }
        catch (IOException ioe) {
            throw new XPathException((Throwable)ioe);
        }
    }
}

