/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.exist.util.Base64Decoder;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.image.GetHeightFunction;
import org.exist.xquery.modules.image.GetMetadataFunction;
import org.exist.xquery.modules.image.GetThumbnailsFunction;
import org.exist.xquery.modules.image.GetWidthFunction;
import org.exist.xquery.modules.image.ScaleFunction;
import org.exist.xquery.value.Base64Binary;

public class ImageModule
extends AbstractInternalModule {
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/image";
    public static final String PREFIX = "image";
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(GetWidthFunction.signature, GetWidthFunction.class), new FunctionDef(GetHeightFunction.signature, GetHeightFunction.class), new FunctionDef(GetMetadataFunction.signature, GetMetadataFunction.class), new FunctionDef(ScaleFunction.signature, ScaleFunction.class), new FunctionDef(GetThumbnailsFunction.signature, GetThumbnailsFunction.class)};

    public ImageModule() {
        super(functions);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing operations on Images stored in the eXist db";
    }

    protected static byte[] getImageData(Base64Binary imgBase64Data) throws XPathException {
        Base64Decoder dec = new Base64Decoder();
        dec.translate((CharSequence)imgBase64Data.getStringValue());
        return dec.getByteArray();
    }

    protected static Image getImage(Base64Binary imgBase64Data) throws IOException, XPathException {
        return ImageIO.read(new ByteArrayInputStream(ImageModule.getImageData(imgBase64Data)));
    }

    protected static BufferedImage createThumb(Image image, int height, int width) {
        int imageWidth;
        int thumbWidth = 0;
        int thumbHeight = 0;
        double scaleFactor = 0.0;
        BufferedImage thumbImage = null;
        Graphics2D graphics2D = null;
        int imageHeight = image.getHeight(null);
        if (imageHeight >= (imageWidth = image.getWidth(null))) {
            scaleFactor = (double)height / (double)imageHeight;
            thumbWidth = (int)((double)imageWidth * scaleFactor);
            thumbHeight = height;
            if (thumbWidth > width) {
                scaleFactor = (double)width / (double)thumbWidth;
                thumbHeight = (int)((double)thumbHeight * scaleFactor);
                thumbWidth = width;
            }
        } else {
            scaleFactor = (double)width / (double)imageWidth;
            thumbHeight = (int)((double)imageHeight * scaleFactor);
            thumbWidth = width;
            if (thumbHeight > height) {
                scaleFactor = (double)height / (double)thumbHeight;
                thumbWidth = (int)((double)thumbWidth * scaleFactor);
                thumbHeight = height;
            }
        }
        thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        return thumbImage;
    }
}

