/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exist.dom.QName;
import org.exist.util.Base64Encoder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.system.GetVersion;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SendEmailFunction
extends BasicFunction {
    private String charset;
    public static final FunctionSignature signature = new FunctionSignature(new QName("send-email", "http://exist-db.org/xquery/mail", "mail"), "Sends an email $a through the SMTP Server $b, or if $b is () tries to use the local sendmail program. $a is the email in the following format <mail><from/><reply-to/><to/><cc/><bcc/><subject/><message><text/><xhtml/></message><attachment filename=\"\" mimetype=\"\">xs:base64Binary</attachment></mail>. $c defines the charset value used in the \"Content-Type\" message header (Defaults to UTF-8)", new SequenceType[]{new SequenceType(-1, 2), new SequenceType(22, 3), new SequenceType(22, 3)}, new SequenceType(23, 2));

    public SendEmailFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            this.charset = !args[2].isEmpty() ? args[2].getStringValue() : "UTF-8";
            Mail theMail = this.ParseMailXML(((NodeValue)args[0].itemAt(0)).getNode());
            if (!args[1].isEmpty() ? this.SendSMTP(theMail, args[1].getStringValue()) : this.SendSendmail(theMail)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        catch (TransformerException e) {
            throw new XPathException("Could not Transform XHTML Message Body: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean SendSendmail(Mail aMail) {
        try {
            Vector allrecipients = new Vector();
            allrecipients.addAll(aMail.getTo());
            allrecipients.addAll(aMail.getCC());
            allrecipients.addAll(aMail.getBCC());
            String recipients = "";
            for (int x = 0; x < allrecipients.size(); ++x) {
                recipients = ((String)allrecipients.elementAt(x)).indexOf("<") != -1 ? recipients + " " + ((String)allrecipients.elementAt(x)).substring(((String)allrecipients.elementAt(x)).indexOf("<") + 1, ((String)allrecipients.elementAt(x)).indexOf(">")) : recipients + " " + (String)allrecipients.elementAt(x);
            }
            Process p = Runtime.getRuntime().exec("/usr/sbin/sendmail" + recipients);
            PrintWriter out = new PrintWriter(new OutputStreamWriter(p.getOutputStream(), this.charset));
            this.WriteMessage(out, aMail);
            out.close();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return false;
        }
        LOG.info((Object)("send-email() message sent using Sendmail " + new Date()));
        return true;
    }

    private boolean SendSMTP(Mail aMail, String SMTPServer) {
        int TCP_PROTOCOL_SMTP = 25;
        String SMTPResult = "";
        try {
            Socket smtpSock = new Socket(SMTPServer, 25);
            BufferedReader in = new BufferedReader(new InputStreamReader(smtpSock.getInputStream()));
            PrintWriter out = new PrintWriter(new OutputStreamWriter(smtpSock.getOutputStream(), this.charset));
            SMTPResult = in.readLine();
            if (!SMTPResult.substring(0, 3).toString().equals("220")) {
                LOG.error((Object)"Error - SMTP Server not ready!");
                return false;
            }
            out.println("HELO " + InetAddress.getLocalHost().getHostName());
            out.flush();
            SMTPResult = in.readLine();
            if (!SMTPResult.substring(0, 3).toString().equals("250")) {
                LOG.error((Object)("Error - SMTP HELO Failed: " + SMTPResult));
                return false;
            }
            if (aMail.getFrom().indexOf("<") != -1) {
                out.println("MAIL FROM: " + aMail.getFrom().substring(aMail.getFrom().indexOf("<") + 1, aMail.getFrom().indexOf(">")));
            } else {
                out.println("MAIL FROM: " + aMail.getFrom());
            }
            out.flush();
            SMTPResult = in.readLine();
            if (!SMTPResult.substring(0, 3).toString().equals("250")) {
                LOG.error((Object)("Error - SMTP MAIL FROM failed: " + SMTPResult));
                return false;
            }
            Vector allrecipients = new Vector();
            allrecipients.addAll(aMail.getTo());
            allrecipients.addAll(aMail.getCC());
            allrecipients.addAll(aMail.getBCC());
            for (int x = 0; x < allrecipients.size(); ++x) {
                if (((String)allrecipients.elementAt(x)).indexOf("<") != -1) {
                    out.println("RCPT TO: " + ((String)allrecipients.elementAt(x)).substring(((String)allrecipients.elementAt(x)).indexOf("<") + 1, ((String)allrecipients.elementAt(x)).indexOf(">")));
                } else {
                    out.println("RCPT TO: " + (String)allrecipients.elementAt(x));
                }
                out.flush();
                SMTPResult = in.readLine();
                if (SMTPResult.substring(0, 3).toString().equals("250")) continue;
                LOG.error((Object)("Error - SMTP RCPT TO failed: " + SMTPResult));
            }
            out.println("DATA");
            out.flush();
            SMTPResult = in.readLine();
            if (!SMTPResult.substring(0, 3).toString().equals("354")) {
                LOG.error((Object)("Error - SMTP DATA failed: " + SMTPResult));
                return false;
            }
            this.WriteMessage(out, aMail);
            SMTPResult = in.readLine();
            if (!SMTPResult.substring(0, 3).toString().equals("250")) {
                LOG.error((Object)("Error - Message not accepted: " + SMTPResult));
                return false;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return false;
        }
        LOG.info((Object)("send-email() message sent using SMTP " + new Date()));
        return true;
    }

    private void WriteMessage(PrintWriter out, Mail aMail) throws IOException {
        int x;
        String Version2 = this.eXistVersion();
        String MultipartBoundary = "eXist.multipart." + Version2;
        out.println("From: " + this.encode64Address(aMail.getFrom()));
        if (aMail.getReplyTo() != null) {
            out.println("Reply-To: " + this.encode64Address(aMail.getReplyTo()));
        }
        for (x = 0; x < aMail.countTo(); ++x) {
            out.println("To: " + this.encode64Address(aMail.getTo(x)));
        }
        for (x = 0; x < aMail.countCC(); ++x) {
            out.println("CC: " + this.encode64Address(aMail.getCC(x)));
        }
        for (x = 0; x < aMail.countBCC(); ++x) {
            out.println("BCC: " + this.encode64Address(aMail.getBCC(x)));
        }
        out.println("Date: " + this.getDateRFC822());
        out.println("Subject: " + this.encode64(aMail.getSubject()));
        out.println("X-Mailer: eXist " + Version2 + " util:send-email()");
        out.println("MIME-Version: 1.0");
        boolean multipartAlternative = false;
        String multipartBoundary = null;
        if (aMail.attachmentIterator().hasNext()) {
            multipartBoundary = MultipartBoundary;
        } else if (!aMail.getText().equals("") && !aMail.getXHTML().equals("")) {
            multipartAlternative = true;
            multipartBoundary = MultipartBoundary + "_alt";
        }
        if (multipartBoundary != null) {
            out.println("Content-Type: " + (multipartAlternative ? "multipart/alternative" : "multipart/mixed") + "; boundary=\"" + multipartBoundary + "\";");
            out.println();
            out.println("Error your mail client is not MIME Compatible");
            out.println("--" + multipartBoundary);
        }
        if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
            out.println("Content-Type: multipart/alternative; boundary=\"" + MultipartBoundary + "_alt\";");
            out.println("--" + MultipartBoundary + "_alt");
        }
        if (!aMail.getText().toString().equals("")) {
            out.println("Content-Type: text/plain; charset=" + this.charset);
            out.println("Content-Transfer-Encoding: 8bit");
            out.println();
            out.println(aMail.getText());
            if (multipartBoundary != null) {
                if (!aMail.getXHTML().toString().equals("") || aMail.attachmentIterator().hasNext()) {
                    if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                        out.println("--" + MultipartBoundary + "_alt");
                    } else {
                        out.println("--" + multipartBoundary);
                    }
                } else if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                    out.println("--" + MultipartBoundary + "_alt--");
                } else {
                    out.println("--" + multipartBoundary + "--");
                }
            }
        }
        if (!aMail.getXHTML().toString().equals("")) {
            out.println("Content-Type: text/html; charset=" + this.charset);
            out.println("Content-Transfer-Encoding: 8bit");
            out.println();
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
            out.println(aMail.getXHTML());
            if (multipartBoundary != null) {
                if (aMail.attachmentIterator().hasNext()) {
                    if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                        out.println("--" + MultipartBoundary + "_alt--");
                        out.println("--" + multipartBoundary);
                    } else {
                        out.println("--" + multipartBoundary);
                    }
                } else if (!aMail.getText().toString().equals("") && !aMail.getXHTML().toString().equals("") && aMail.attachmentIterator().hasNext()) {
                    out.println("--" + MultipartBoundary + "_alt--");
                } else {
                    out.println("--" + multipartBoundary + "--");
                }
            }
        }
        if (aMail.attachmentIterator().hasNext()) {
            Iterator itAttachment = aMail.attachmentIterator();
            while (itAttachment.hasNext()) {
                MailAttachment ma = (MailAttachment)itAttachment.next();
                out.println("Content-Type: " + ma.getMimeType() + "; name=\"" + ma.getFilename() + "\"");
                out.println("Content-Transfer-Encoding: base64");
                out.println("Content-Description: " + ma.getFilename());
                out.println("Content-Disposition: attachment; filname=\"" + ma.getFilename() + "\"");
                out.println();
                out.println(ma.getData());
                if (!itAttachment.hasNext()) continue;
                out.println("--" + multipartBoundary);
            }
            out.println("--" + multipartBoundary + "--");
        }
        out.println();
        out.println(".");
        out.println();
        out.flush();
    }

    private String eXistVersion() throws IOException {
        Properties sysProperties = new Properties();
        sysProperties.load(GetVersion.class.getClassLoader().getResourceAsStream("org/exist/system.properties"));
        return sysProperties.getProperty("product-version", "unknown version");
    }

    private Mail ParseMailXML(Node message) throws TransformerException {
        Mail theMail = new Mail();
        if (message.getNodeType() == 1 && message.getLocalName().equals("mail")) {
            for (Node child = message.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.hasChildNodes()) continue;
                if (child.getLocalName().equals("from")) {
                    theMail.setFrom(child.getFirstChild().getNodeValue());
                }
                if (child.getLocalName().equals("reply-to")) {
                    theMail.setReplyTo(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("to")) {
                    theMail.addTo(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("cc")) {
                    theMail.addCC(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("bcc")) {
                    theMail.addBCC(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("subject")) {
                    theMail.setSubject(child.getFirstChild().getNodeValue());
                    continue;
                }
                if (child.getLocalName().equals("message")) {
                    for (Node bodyPart = child.getFirstChild(); bodyPart != null; bodyPart = bodyPart.getNextSibling()) {
                        if (bodyPart.getLocalName().equals("text")) {
                            theMail.setText(bodyPart.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!bodyPart.getLocalName().equals("xhtml")) continue;
                        TransformerFactory transFactory = TransformerFactory.newInstance();
                        Transformer transformer = transFactory.newTransformer();
                        DOMSource source = new DOMSource(bodyPart.getFirstChild());
                        StringWriter strWriter = new StringWriter();
                        StreamResult result = new StreamResult(strWriter);
                        transformer.transform(source, result);
                        theMail.setXHTML(strWriter.toString());
                    }
                    continue;
                }
                if (!child.getLocalName().equals("attachment")) continue;
                Element attachment = (Element)child;
                MailAttachment ma = new MailAttachment(attachment.getAttribute("filename"), attachment.getAttribute("mimetype"), attachment.getFirstChild().getNodeValue());
                theMail.addAttachment(ma);
            }
        }
        return theMail;
    }

    private String getDateRFC822() {
        String tSecond;
        String tMinute;
        String dateString = new String();
        Calendar rightNow = Calendar.getInstance();
        switch (rightNow.get(7)) {
            case 2: {
                dateString = "Mon";
                break;
            }
            case 3: {
                dateString = "Tue";
                break;
            }
            case 4: {
                dateString = "Wed";
                break;
            }
            case 5: {
                dateString = "Thu";
                break;
            }
            case 6: {
                dateString = "Fri";
                break;
            }
            case 7: {
                dateString = "Sat";
                break;
            }
            case 1: {
                dateString = "Sun";
            }
        }
        dateString = dateString + ", ";
        dateString = dateString + rightNow.get(5);
        dateString = dateString + " ";
        switch (rightNow.get(2)) {
            case 0: {
                dateString = dateString + "Jan";
                break;
            }
            case 1: {
                dateString = dateString + "Feb";
                break;
            }
            case 2: {
                dateString = dateString + "Mar";
                break;
            }
            case 3: {
                dateString = dateString + "Apr";
                break;
            }
            case 4: {
                dateString = dateString + "May";
                break;
            }
            case 5: {
                dateString = dateString + "Jun";
                break;
            }
            case 6: {
                dateString = dateString + "Jul";
                break;
            }
            case 7: {
                dateString = dateString + "Aug";
                break;
            }
            case 8: {
                dateString = dateString + "Sep";
                break;
            }
            case 9: {
                dateString = dateString + "Oct";
                break;
            }
            case 10: {
                dateString = dateString + "Nov";
                break;
            }
            case 11: {
                dateString = dateString + "Dec";
            }
        }
        dateString = dateString + " ";
        dateString = dateString + rightNow.get(1);
        dateString = dateString + " ";
        String tHour = Integer.toString(rightNow.get(11));
        if (tHour.length() == 1) {
            tHour = "0" + tHour;
        }
        if ((tMinute = Integer.toString(rightNow.get(12))).length() == 1) {
            tMinute = "0" + tMinute;
        }
        if ((tSecond = Integer.toString(rightNow.get(13))).length() == 1) {
            tSecond = "0" + tSecond;
        }
        dateString = dateString + tHour + ":" + tMinute + ":" + tSecond + " ";
        String tzSign = new String();
        String tzHours = new String();
        String tzMinutes = new String();
        TimeZone thisTZ = TimeZone.getDefault();
        int TZOffset = thisTZ.getOffset(rightNow.get(5));
        TZOffset /= 1000;
        tzSign = (TZOffset /= 60) > 1 ? "+" : "-";
        if (TZOffset >= 60 || TZOffset <= -60) {
            if ((tzHours = tzHours + TZOffset / 60).length() == 1) {
                tzHours = "0" + tzHours;
            }
            if ((tzMinutes = tzMinutes + TZOffset % 60).length() == 1) {
                tzMinutes = "0" + tzMinutes;
            }
        } else {
            tzHours = "00";
            if ((tzMinutes = tzMinutes + TZOffset).length() == 1) {
                tzMinutes = "0" + tzMinutes;
            }
        }
        dateString = dateString + tzSign + tzHours + tzMinutes;
        return dateString;
    }

    private String encode64(String str) throws UnsupportedEncodingException {
        Base64Encoder enc = new Base64Encoder();
        enc.translate(str.getBytes(this.charset));
        String result = new String(enc.getCharArray());
        result = result.replaceAll("\n", "?=\n =?" + this.charset + "?B?");
        result = "=?" + this.charset + "?B?" + result + "?=";
        return result;
    }

    private String encode64Address(String str) throws UnsupportedEncodingException {
        int idx = str.indexOf("<");
        String result = idx != -1 ? this.encode64(str.substring(0, idx)) + " " + str.substring(idx) : str;
        return result;
    }

    private class Mail {
        private String from = "";
        private String replyTo = null;
        private Vector to = new Vector();
        private Vector cc = new Vector();
        private Vector bcc = new Vector();
        private String subject = "";
        private String text = "";
        private String xhtml = "";
        private Vector attachment = new Vector();

        private Mail() {
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getFrom() {
            return this.from;
        }

        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public void addTo(String to) {
            this.to.addElement(to);
        }

        public int countTo() {
            return this.to.size();
        }

        public String getTo(int index) {
            return (String)this.to.elementAt(index);
        }

        public Collection getTo() {
            return this.to;
        }

        public void addCC(String cc) {
            this.cc.addElement(cc);
        }

        public int countCC() {
            return this.cc.size();
        }

        public String getCC(int index) {
            return (String)this.cc.elementAt(index);
        }

        public Collection getCC() {
            return this.cc;
        }

        public void addBCC(String bcc) {
            this.bcc.addElement(bcc);
        }

        public int countBCC() {
            return this.bcc.size();
        }

        public String getBCC(int index) {
            return (String)this.bcc.elementAt(index);
        }

        public Collection getBCC() {
            return this.bcc;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setXHTML(String xhtml) {
            this.xhtml = xhtml;
        }

        public String getXHTML() {
            return this.xhtml;
        }

        public void addAttachment(MailAttachment ma) {
            this.attachment.add(ma);
        }

        public Iterator attachmentIterator() {
            return this.attachment.iterator();
        }
    }

    private class MailAttachment {
        private String filename;
        private String mimeType;
        private String data;

        public MailAttachment(String filename, String mimeType, String data) {
            this.filename = filename;
            this.mimeType = mimeType;
            this.data = data;
        }

        public String getData() {
            return this.data;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

