/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.scheduler;

import java.util.Date;
import org.exist.dom.QName;
import org.exist.scheduler.ScheduledJobInfo;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.UserJob;
import org.exist.security.User;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class GetScheduledJobs
extends BasicFunction {
    private Scheduler scheduler = null;
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-scheduled-jobs", "http://exist-db.org/xquery/scheduler", "scheduler"), "Get's details of all Scheduled Jobs", null, new SequenceType(-1, 2));

    public GetScheduledJobs(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.scheduler = context.getBroker().getBrokerPool().getScheduler();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        User user = this.context.getUser();
        boolean userhasDBARole = user.hasDbaRole();
        StringBuffer xmlBuf = new StringBuffer();
        int iJobs = 0;
        String[] groups = this.scheduler.getJobGroupNames();
        ScheduledJobInfo[] scheduledJobs = this.scheduler.getScheduledJobs();
        for (int g = 0; g < groups.length; ++g) {
            if (!userhasDBARole && !groups[g].equals(UserJob.JOB_GROUP)) continue;
            xmlBuf.append("<scheduler:group name=\"" + groups[g] + "\">");
            for (int j = 0; j < scheduledJobs.length; ++j) {
                if (!scheduledJobs[j].getGroup().equals(groups[g])) continue;
                xmlBuf.append("<scheduler:job name=\"" + scheduledJobs[j].getName() + "\">");
                xmlBuf.append("<scheduler:trigger name=\"" + scheduledJobs[j].getTriggerName() + "\">");
                xmlBuf.append("<expression>");
                xmlBuf.append(scheduledJobs[j].getTriggerExpression());
                xmlBuf.append("</expression>");
                xmlBuf.append("<state>");
                xmlBuf.append(scheduledJobs[j].getTriggerState());
                xmlBuf.append("</state>");
                xmlBuf.append("<start>");
                xmlBuf.append(new DateTimeValue(scheduledJobs[j].getStartTime()));
                xmlBuf.append("</start>");
                xmlBuf.append("<end>");
                Date endTime = scheduledJobs[j].getEndTime();
                if (endTime != null) {
                    xmlBuf.append(new DateTimeValue(endTime));
                }
                xmlBuf.append("</end>");
                xmlBuf.append("<previous>");
                Date previousTime = scheduledJobs[j].getPreviousFireTime();
                if (previousTime != null) {
                    xmlBuf.append(new DateTimeValue(scheduledJobs[j].getPreviousFireTime()));
                }
                xmlBuf.append("</previous>");
                xmlBuf.append("<next>");
                Date nextTime = scheduledJobs[j].getNextFireTime();
                if (nextTime != null) {
                    xmlBuf.append(new DateTimeValue());
                }
                xmlBuf.append("</next>");
                xmlBuf.append("<final>");
                Date finalTime = scheduledJobs[j].getFinalFireTime();
                if (endTime != null && finalTime != null) {
                    xmlBuf.append(new DateTimeValue());
                }
                xmlBuf.append("</final>");
                xmlBuf.append("</scheduler:trigger>");
                xmlBuf.append("</scheduler:job>");
                ++iJobs;
            }
            xmlBuf.append("</scheduler:group>");
        }
        xmlBuf.insert(0, "<scheduler:jobs xmlns:scheduler=\"http://exist-db.org/xquery/scheduler\" count=\"" + iJobs + "\">");
        xmlBuf.append("</scheduler:jobs>");
        try {
            return ModuleUtils.stringToXML(this.context, xmlBuf.toString());
        }
        catch (SAXException se) {
            throw new XPathException((Throwable)se);
        }
    }
}

