/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetConnectionFunction
extends BasicFunction {
    static long current = System.currentTimeMillis();
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JDBC Driver class name in $a and a JDBC URL in $b. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(37, 3)), new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JDBC Driver class name in $a and a JDBC URL in $b. Additional JDBC properties may be set in $c in the form <properties><property name=\"\" value=\"\"/></properties>. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(1, 3)}, new SequenceType(37, 3)), new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Open's a connection to a SQL Database. Expects a JDBC Driver class name in $a, a JDBC URL in $b, a username in $c and a password in $d. Returns an xs:long representing the connection handle.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(37, 3))};

    public GetConnectionFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            Connection con = null;
            String dbDriver = args[0].getStringValue();
            String dbURL = args[1].getStringValue();
            Class.forName(dbDriver).newInstance();
            if (args.length == 2) {
                con = DriverManager.getConnection(dbURL);
            } else if (args.length == 3) {
                Properties props = GetConnectionFunction.parseProperties(((NodeValue)args[2].itemAt(0)).getNode());
                con = DriverManager.getConnection(dbURL, props);
            } else if (args.length == 4) {
                String dbUser = args[2].getStringValue();
                String dbPassword = args[3].getStringValue();
                con = DriverManager.getConnection(dbURL, dbUser, dbPassword);
            }
            HashMap<Long, Connection> connections = (HashMap<Long, Connection>)this.context.getXQueryContextVar("_eXist_sql_connections");
            if (connections == null) {
                connections = new HashMap<Long, Connection>();
            }
            long conID = GetConnectionFunction.getUID();
            connections.put(new Long(conID), con);
            this.context.setXQueryContextVar("_eXist_sql_connections", connections);
            return new IntegerValue(conID);
        }
        catch (Exception e) {
            throw new XPathException(e.getMessage());
        }
    }

    private static final Properties parseProperties(Node properties) throws XPathException {
        Properties props = new Properties();
        if (properties.getNodeType() == 1 && properties.getLocalName().equals("properties")) {
            NodeList propertiesList = properties.getChildNodes();
            for (int i = 0; i < propertiesList.getLength(); ++i) {
                Node property = propertiesList.item(i);
                if (property.getNodeType() != 1 || !property.getLocalName().equals("property")) continue;
                String name = ((Element)property).getAttribute("name");
                String value = ((Element)property).getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException("Name or value attribute missing for property parameter");
                }
                props.put(name, value);
            }
        }
        return props;
    }

    private static synchronized long getUID() {
        return current++;
    }

    protected static final void closeAll(XQueryContext xqueryContext) {
        HashMap connections = (HashMap)xqueryContext.getXQueryContextVar("_eXist_sql_connections");
        if (connections != null) {
            Set keys = connections.keySet();
            Iterator itKeys = keys.iterator();
            while (itKeys.hasNext()) {
                Long conID = (Long)itKeys.next();
                Connection con = (Connection)connections.get(conID);
                try {
                    con.close();
                    connections.remove(conID);
                }
                catch (SQLException se) {
                    LOG.debug((Object)"Unable to close JDBC connection", (Throwable)se);
                }
            }
            xqueryContext.setXQueryContextVar("_eXist_sql_connections", (Object)connections);
        }
    }
}

