/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.xmldiff;

import org.custommonkey.xmlunit.Diff;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class Compare
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("compare", "http://exist-db.org/xquery/xmldiff", "xmldiff"), "Returns the differences between XML documents", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(-1, 7)}, new SequenceType(23, 3));

    public Compare(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Expression arg1 = this.getArgument(0);
        Sequence s1 = arg1.eval(contextSequence, contextItem);
        Expression arg2 = this.getArgument(1);
        this.context.pushDocumentContext();
        Sequence s2 = arg2.eval(contextSequence, contextItem);
        this.context.popDocumentContext();
        if (s1.isEmpty()) {
            return BooleanValue.valueOf((boolean)s2.isEmpty());
        }
        if (s2.isEmpty()) {
            return BooleanValue.valueOf((boolean)s1.isEmpty());
        }
        BooleanValue result = null;
        StringBuffer v1 = new StringBuffer();
        StringBuffer v2 = new StringBuffer();
        try {
            int i;
            if (s1.hasMany()) {
                for (i = 0; i < s1.getItemCount(); ++i) {
                    v1.append(this.serialize((NodeValue)s1.itemAt(i)));
                }
            } else {
                v1.append(this.serialize((NodeValue)s1.itemAt(0)));
            }
            if (s2.hasMany()) {
                for (i = 0; i < s2.getItemCount(); ++i) {
                    v2.append(this.serialize((NodeValue)s2.itemAt(i)));
                }
            } else {
                v2.append(this.serialize((NodeValue)s2.itemAt(0)));
            }
            Diff d = new Diff(v1.toString(), v2.toString());
            result = new BooleanValue(d.identical());
        }
        catch (Exception e) {
            throw new XPathException(this.getASTNode(), "An exception occurred while serializing node for comparison: " + e.getMessage(), (Throwable)e);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end((Expression)this, "", (Sequence)result);
        }
        return result;
    }

    private String serialize(NodeValue node) throws SAXException {
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        return serializer.serialize(node);
    }
}

