//$Header: /Development/AEDevelopment/projects/org.activebpel.rt.bpel.server/src/org/activebpel/rt/bpel/server/engine/storage/IAeCoordinationStorage.java,v 1.6 2007/04/03 20:54:32 EWittmann Exp $
/////////////////////////////////////////////////////////////////////////////
//PROPRIETARY RIGHTS STATEMENT
//The contents of this file represent confidential information that is the
//proprietary property of Active Endpoints, Inc.  Viewing or use of
//this information is prohibited without the express written consent of
//Active Endpoints, Inc. Removal of this PROPRIETARY RIGHTS STATEMENT
//is strictly forbidden. Copyright (c) 2002-2005 All rights reserved.
/////////////////////////////////////////////////////////////////////////////
package org.activebpel.rt.bpel.server.engine.storage;

import java.util.List;

import org.activebpel.rt.bpel.coord.IAeCoordinating;
import org.activebpel.rt.bpel.coord.IAeCoordinationManager;
import org.activebpel.rt.bpel.server.coord.AeCoordinationContext;
import org.activebpel.rt.bpel.server.coord.AeCreateContextRequest;
import org.activebpel.rt.bpel.server.coord.AePersistentCoordinationId;
import org.activebpel.rt.bpel.server.coord.IAeCoordinationId;

/**
 * Interface for coordination persistence storage layer.
 */
public interface IAeCoordinationStorage extends IAeStorage
{
   /**
    * Sets the coordination manager.
    * @param aManager
    */
   public void setCoordinationManager(IAeCoordinationManager aManager);

   /**
    * Creates a coordination context. If the coordination id is null, a new coordination
    * id will be generated by the storage layer.
    * @param aCtxRequest
    * @param aCoordinationId
    * @param aState
    * @param aRole
    * @throws AeStorageException
    */
   public AeCoordinationContext createContext(AeCreateContextRequest aCtxRequest, IAeCoordinationId aCoordinationId, String aState, int aRole) throws AeStorageException;

   /**
    * Returns list of coordinations matching the process id and coordination id.
    * @param aCoordinationId
    * @param aProcessId
    * @throws AeStorageException
    */
   public IAeCoordinating getCoordination(String aCoordinationId, long aProcessId) throws AeStorageException;
   
   /**
    * Returns all coordinations matching the given process id.
    * @param aProcessId
    * @throws AeStorageException
    */
   public List getCoordinationsByProcessId(long aProcessId) throws AeStorageException;

   /**
    * Returns list of coordinations with matching coordination id.
    * @param aCoordinationId
    * @throws AeStorageException
    */
   public List getCoordinations(String aCoordinationId) throws AeStorageException;
   
   /**
    * Updates the state of the given coordination id.
    * @param aCoordinationId
    * @param aState
    * @throws AeStorageException
    */
   public void updateCoordinationState(AePersistentCoordinationId aCoordinationId, String aState) throws AeStorageException;
   
   /**
    * Updates the context of the coordination.
    * @param aCoordinationId
    * @param aContext
    * @throws AeStorageException
    */
   public void updateCoordinationContext(AePersistentCoordinationId aCoordinationId, AeCoordinationContext aContext) throws AeStorageException;
   
   /**
    * Returns the coordinator (parent) detail given a participant (child) process id.
    * @param aChildProcessId
    * @throws AeStorageException
    */
   public List getCoordinatorDetail(long aChildProcessId) throws AeStorageException;
   
   /**
    * Returns a list of participants (children) given the coordinator (parent) process id.
    * @param aParentProcessId
    * @throws AeStorageException
    */
   public List getParticipantDetail(long aParentProcessId) throws AeStorageException;
}
