//$Header: /Development/AEDevelopment/projects/org.activebpel.rt.bpel/src/org/activebpel/rt/bpel/coord/AeCoordinationFaultException.java,v 1.2 2006/01/19 20:13:53 PJayanetti Exp $
/////////////////////////////////////////////////////////////////////////////
//PROPRIETARY RIGHTS STATEMENT
//The contents of this file represent confidential information that is the
//proprietary property of Active Endpoints, Inc.  Viewing or use of
//this information is prohibited without the express written consent of
//Active Endpoints, Inc. Removal of this PROPRIETARY RIGHTS STATEMENT
//is strictly forbidden. Copyright (c) 2002-2005 All rights reserved.
/////////////////////////////////////////////////////////////////////////////
package org.activebpel.rt.bpel.coord;

/**
 * Exception generated by either the coordinator or the particpant
 * due to errors related to the coordination activity.
 * 
 * Note: This is an internal implementation tailored to be used with requirement 111
 * i.e. the coordination error type is a simple string code instead of the wscoord name spaced
 * fault code (which would be sent as part of the SOAP faults). 
 * 
 * The final implemention should follow the Coordination faults described as per
 * WS-Coordination RFC section 4.
 *  
 */
public class AeCoordinationFaultException extends AeCoordinationException
{
   public static final String  INVALID_STATE       = "aecoor:InvalidState"; //$NON-NLS-1$
   public static final String  INVALID_PROTOCOL    = "aecoor:InvalidProtocol"; //$NON-NLS-1$
   public static final String  INVALID_PARAMETERS  = "aecoor:InvalidParameters"; //$NON-NLS-1$
   public static final String  NO_ACTIVITY         = "aecoor:NoActivity"; //$NON-NLS-1$
   public static final String  CONTEXT_REFUSED     = "aecoor:ContextRefused"; //$NON-NLS-1$
   public static final String  ALREADY_REGISTERED  = "aecoor:AlreadyRegistered"; //$NON-NLS-1$
   
   /**
    * Fault code.
    */
   private String mFaultCode = ""; //$NON-NLS-1$
   
   /**
    * Constructs the fault given the fault code.
    * @param aFaultCode faultCode as per WSBA specifcation.
    */
   public AeCoordinationFaultException(String aFaultCode)
   {
      super(aFaultCode);
      setFaultCode(aFaultCode);
   }

   /**
    * Construct the fault object given the fault code and a descriptive fault message.
    * @param aFaultCode faultCode as per WSBA specifcation.   
    * @param aInfo error message.
    */
   public AeCoordinationFaultException(String aFaultCode, String aInfo)
   {
      super(aInfo);
      setFaultCode(aFaultCode);
   }

   /**
    * Construct the fault object given the fault code and the root cause. 
    * @param aFaultCode faultCode as per WSBA specifcation.  
    * @param aRootCause root cause.
    */
   public AeCoordinationFaultException(String aFaultCode, Throwable aRootCause)
   {
      super(aRootCause);
      setFaultCode(aFaultCode);
   }

   /**
    * Construct the fault object given the fault code, description and the root cause. 
    * @param aFaultCode faultCode as per WSBA specifcation.   
    * @param aInfo fault description or message.
    * @param aRootCause root cause.
    */
   public AeCoordinationFaultException(String aFaultCode, String aInfo, Throwable aRootCause)
   {
      super(aInfo, aRootCause);
      setFaultCode(aFaultCode);
   }
   
   /**
    * @return Returns the faultCode.
    */
   public String getFaultCode()
   {
      return mFaultCode;
   }
   
   /**
    * @param aFaultCode The faultCode to set.
    */
   public void setFaultCode(String aFaultCode)
   {
      mFaultCode = aFaultCode;
   }
}
