module ActiveWarehouse
  module Aggregate
    module Dwarf
      class NodeStruct < BinData::Struct
        uint32 :id
        uint16 :cells_length
        array :cells, :type => :cell_struct, :initial_length => :cells_length
        struct :all_cell, :type => :cell_struct
      end
      class CellStruct < BinData::Struct
        uint8 :key_len
        string :key, :initial_length => :key_len
        uint16 :value # may be a value or a pointer
      end
      class DwarfWriter
        def write(node)
          n = NodeStruct.new
          n.id = node.id
          n.cells_length = node.cells.length
          
          node.cells.each do |cell|
            c = CellStruct.new
            c.key_len = cell.key.length
            c.key = cell.key
            n.cells << c
          end
          
          ac = CellStruct.new
          ac.key_len = n.all_cell.key.length
          ac.key = n.all_cell.key
          n.all_cell = ac
        end
      end
    end
  end
end