/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.tools.sendsoap.cline;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.ode.tools.ToolMessages;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.cli.Argument;
import org.apache.ode.utils.cli.BaseCommandlineTool;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.ConsoleFormatter;
import org.apache.ode.utils.cli.FlagWithArgument;
import org.apache.ode.utils.cli.Fragments;
import org.apache.ode.utils.msg.CommonMessages;
import org.apache.ode.utils.msg.MessageBundle;

public class HttpSoapSender
extends BaseCommandlineTool {
    private static final int RETURN_BAD_URL = 2;
    private static final int RETURN_SEND_ERROR = 3;
    private static final int RETURN_CANT_READ = 4;
    private static final int RETURN_CANT_WRITE = 5;
    private static final int RETURN_BAD_PORT = 6;
    private static Pattern SEQ = Pattern.compile("\\$sequence\\$");
    private static final ToolMessages MESSAGES = (ToolMessages)MessageBundle.getMessages(ToolMessages.class);
    private static final CommonMessages COMMON = (CommonMessages)MessageBundle.getMessages(CommonMessages.class);
    private static final Argument URL_A = new Argument("url", "the URL to send the SOAP to.", false);
    private static final Argument FILE_A = new Argument("file", "the file that contains the SOAP to send.", false);
    private static final FlagWithArgument PROXY_SERVER = new FlagWithArgument("s", "proxyServer", "server to use for proxy authentication.", true);
    private static final FlagWithArgument PROXY_PORT = new FlagWithArgument("p", "proxyPort", "port to use for proxy authentication.", true);
    private static final FlagWithArgument PROXY_USER = new FlagWithArgument("u", "username", "username to use for proxy authentication.", true);
    private static final FlagWithArgument PROXY_PASS = new FlagWithArgument("w", "password", "password to use for proxy authentication.", true);
    private static final FlagWithArgument SOAP_ACTION = new FlagWithArgument("a", "soapAction", "SOAP action to include in the message header.", true);
    private static final FlagWithArgument OUTFILE_FWA = new FlagWithArgument("o", "outfile", "a file to write the output to (instead of standard out).", true);
    private static final Fragments CLINE = new Fragments(new CommandlineFragment[]{OUTFILE_FWA, URL_A, FILE_A, PROXY_SERVER, PROXY_PORT, PROXY_USER, PROXY_PASS, SOAP_ACTION});
    private static final String SYNOPSIS = "send the contents of a file to a URL as a SOAP request and print the response (if any) to the console or a file.";

    protected static String getProgramName() {
        return "sendsoap";
    }

    public static void doSend(URL uRL, InputStream inputStream, OutputStream outputStream, String string, int n, String string2, String string3, String string4) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        StreamUtils.copy((OutputStream)byteArrayOutputStream, (InputStream)inputStream);
        String string5 = Long.toString(System.currentTimeMillis());
        int n2 = 1;
        String string6 = new String(byteArrayOutputStream.toByteArray());
        Matcher matcher = SEQ.matcher(string6);
        StringBuffer stringBuffer = new StringBuffer(8192);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, string5 + "-" + n2++);
        }
        matcher.appendTail(stringBuffer);
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(uRL.toExternalForm());
        if (string != null && string.length() > 0) {
            httpClient.getState().setCredentials(new AuthScope(string, n), (Credentials)new UsernamePasswordCredentials(string2, string3));
            postMethod.setDoAuthentication(true);
        }
        if (string4 == null) {
            string4 = "";
        }
        postMethod.setRequestHeader("SOAPAction", "\"" + string4 + "\"");
        postMethod.setRequestHeader("Content-Type", "text/xml");
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(stringBuffer.toString()));
        httpClient.executeMethod((HttpMethod)postMethod);
        String string7 = postMethod.getResponseBodyAsString();
        if (string7 != null) {
            outputStream.write(string7.getBytes());
            outputStream.write("\n".getBytes());
        }
    }

    public static void main(String[] stringArray) {
        boolean bl;
        Object object;
        Object object2;
        if (stringArray.length == 0 || HELP.matches(stringArray)) {
            ConsoleFormatter.printSynopsis((String)HttpSoapSender.getProgramName(), (String)SYNOPSIS, (Fragments[])new Fragments[]{CLINE, HELP});
            System.exit(0);
        } else if (!CLINE.matches(stringArray)) {
            HttpSoapSender.consoleErr((String)("INVALID COMMANDLINE: Try \"" + HttpSoapSender.getProgramName() + " -h\" for help."));
            System.exit(-1);
        }
        OutputStream outputStream = null;
        if (OUTFILE_FWA.isSet()) {
            object2 = OUTFILE_FWA.getValue();
            object = new File((String)object2);
            try {
                outputStream = new FileOutputStream((File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                HttpSoapSender.consoleErr((String)COMMON.msgCannotWriteToFile((String)object2));
                System.exit(5);
            }
        } else {
            outputStream = System.out;
        }
        object2 = null;
        try {
            object2 = new URL(URL_A.getValue());
        }
        catch (MalformedURLException malformedURLException) {
            HttpSoapSender.consoleErr((String)MESSAGES.msgBadUrl(URL_A.getValue(), malformedURLException.getMessage()));
            System.exit(2);
        }
        object = null;
        String string = FILE_A.getValue();
        if (string.equals("-")) {
            object = System.in;
        } else {
            File file = new File(string);
            try {
                object = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                HttpSoapSender.consoleErr((String)COMMON.msgCannotReadFromFile(string));
                System.exit(4);
            }
        }
        boolean bl2 = bl = PROXY_SERVER.getValue() != null && PROXY_SERVER.getValue().length() > 0;
        if (bl) {
            String string2 = PROXY_PORT.getValue();
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                HttpSoapSender.consoleErr((String)COMMON.msgBadPort(string2));
                System.exit(6);
            }
        }
        HttpSoapSender.initLogging();
        try {
            HttpSoapSender.doSend((URL)object2, (InputStream)object, outputStream, PROXY_SERVER.getValue(), bl ? Integer.parseInt(PROXY_PORT.getValue()) : 0, PROXY_USER.getValue(), PROXY_PASS.getValue(), SOAP_ACTION.getValue());
        }
        catch (IOException iOException) {
            HttpSoapSender.consoleErr((String)MESSAGES.msgIoErrorOnSend(iOException.getMessage()));
            System.exit(3);
        }
    }
}

