/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.utils.ISO8601DateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelEventFilter
extends Filter<Criteria>
implements Serializable {
    private static final long serialVersionUID = 9999L;
    private String _type;
    private List<Filter.Restriction<Date>> _tstampRestrictions = new ArrayList<Filter.Restriction<Date>>();
    public int limit;

    public BpelEventFilter(String string, int n) {
        this.init(string);
        this.limit = n;
    }

    public String getTypeFilter() {
        return this._type;
    }

    public List<Filter.Restriction<Date>> getTimestampFilter() {
        return this._tstampRestrictions;
    }

    @Override
    protected Criteria parseKey(String string) {
        return Criteria.valueOf(string);
    }

    protected Criteria[] getFilterKeys() {
        return Criteria.values();
    }

    @Override
    protected void process(Criteria criteria, Filter.Restriction<String> restriction) {
        criteria.process(this, restriction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Criteria {
        TYPE{

            @Override
            void process(BpelEventFilter bpelEventFilter, Filter.Restriction<String> restriction) {
                bpelEventFilter._type = (String)restriction.value;
            }
        }
        ,
        TIMESTAMP{

            @Override
            void process(BpelEventFilter bpelEventFilter, Filter.Restriction<String> restriction) {
                try {
                    bpelEventFilter._tstampRestrictions.add(new Filter.Restriction<Date>(restriction.originalKey, restriction.op, ISO8601DateParser.parse((String)((String)restriction.value))));
                }
                catch (ParseException parseException) {
                    String string = Filter.__msgs.msgISODateParseErr(TIMESTAMP.name(), (String)restriction.value);
                    throw new IllegalArgumentException(string, parseException);
                }
            }
        };


        abstract void process(BpelEventFilter var1, Filter.Restriction<String> var2);
    }
}

