/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.pmapi.InvalidRequestException;
import org.apache.ode.utils.ISO8601DateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceFilter
extends Filter<Criteria>
implements Serializable {
    protected static Log LOG = LogFactory.getLog(InstanceFilter.class);
    private static final long serialVersionUID = 9999L;
    private String iid;
    private String pid;
    private String nameFilter;
    private String namespaceFilter;
    private List<String> statusFilter;
    private List<String> startedDateFilter;
    private List<String> lastActiveDateFilter;
    private Map<String, String> propertyValuesFilter;
    public List<String> orders;
    private int limit;

    public InstanceFilter(String string, String string2, int n) {
        this.init(string);
        if (this.statusFilter != null) {
            for (String string3 : this.statusFilter) {
                try {
                    StatusKeys.valueOf(string3.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidRequestException("The status you're using in your filter isn't valid, only the active, suspended, error, completed, terminated and faulted status are valid. " + illegalArgumentException.toString());
                }
            }
        }
        if (this.startedDateFilter != null) {
            for (String string3 : this.startedDateFilter) {
                try {
                    ISO8601DateParser.parse((String)InstanceFilter.getDateWithoutOp(string3));
                }
                catch (ParseException parseException) {
                    throw new InvalidRequestException("Couldn't parse one of the filter date, please make sure it follows the ISO-8601 date or date/time standard (yyyyMMddhhmmss). " + parseException.toString());
                }
            }
        }
        if (this.lastActiveDateFilter != null) {
            for (String string3 : this.lastActiveDateFilter) {
                try {
                    ISO8601DateParser.parse((String)InstanceFilter.getDateWithoutOp(string3));
                }
                catch (ParseException parseException) {
                    throw new InvalidRequestException("Couldn't parse one of the filter date, please make sure it follows the ISO-8601 date or date/time standard (yyyyMMddhhmmss). " + parseException.toString());
                }
            }
        }
        if (string2 != null && string2.length() > 0) {
            this.orders = new ArrayList<String>(3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                string3 = stringTokenizer.nextToken();
                try {
                    String string4 = string3;
                    if (string4.startsWith("-") || string4.startsWith("+")) {
                        string4 = string3.substring(1, string4.length());
                    }
                    OrderKeys.valueOf(string4.replaceAll("-", "_").toUpperCase());
                    this.orders.add(string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidRequestException("One of the ordering keys isn't valid, processes can only be sorted by pid, name, namespace, version, status, started and last-active date." + illegalArgumentException.toString());
                }
            }
        }
        if (n < 0) {
            throw new IllegalArgumentException("Limit should be greater or equal to 0.");
        }
        this.limit = n;
    }

    public InstanceFilter(String string) {
        this(string, null, Integer.MAX_VALUE);
    }

    public List<Short> convertFilterState() {
        ArrayList<Short> arrayList = new ArrayList<Short>(5);
        short s = 200;
        for (String string : this.statusFilter) {
            if (StatusKeys.ACTIVE.toString().equalsIgnoreCase(string)) {
                arrayList.add((short)0);
                arrayList.add((short)20);
                arrayList.add((short)10);
                continue;
            }
            if (StatusKeys.SUSPENDED.toString().equalsIgnoreCase(string)) {
                arrayList.add((short)50);
                continue;
            }
            if (StatusKeys.ERROR.toString().equalsIgnoreCase(string)) {
                arrayList.add(s);
                continue;
            }
            if (StatusKeys.COMPLETED.toString().equalsIgnoreCase(string)) {
                arrayList.add((short)30);
                continue;
            }
            if (StatusKeys.TERMINATED.toString().equalsIgnoreCase(string)) {
                arrayList.add((short)60);
                continue;
            }
            if (StatusKeys.FAILED.toString().equalsIgnoreCase(string)) {
                arrayList.add((short)40);
                continue;
            }
            arrayList.add(s);
        }
        return arrayList;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public String getNamespaceFilter() {
        return this.namespaceFilter;
    }

    public List<String> getStatusFilter() {
        return this.statusFilter;
    }

    public List<String> getStartedDateFilter() {
        return this.startedDateFilter;
    }

    public List<String> getLastActiveDateFilter() {
        return this.lastActiveDateFilter;
    }

    public Map<String, String> getPropertyValuesFilter() {
        return this.propertyValuesFilter;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public String getPidFilter() {
        return this.pid;
    }

    public String getIidFilter() {
        return this.iid;
    }

    public static void main(String[] stringArray) {
        InstanceFilter instanceFilter = new InstanceFilter("name = dtc* namespace=http://www.intalio.com* status=active|terminated started>=2005-11-29T15:15:19 started<2005-11-29T15:15:20 last-active < 2005-11-30 ${http://ode.org/}order-id= 12 $shipping-id=aa45fz", "name started", 50);
        System.out.println(instanceFilter);
    }

    @Override
    protected Criteria parseKey(String string) {
        if (string.startsWith("$")) {
            return Criteria.PROPERTY;
        }
        return Criteria.valueOf(string);
    }

    protected Criteria[] getFilterKeys() {
        return Criteria.values();
    }

    @Override
    protected void process(Criteria criteria, Filter.Restriction<String> restriction) {
        criteria.process(this, restriction.originalKey, restriction.op, (String)restriction.value);
    }

    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InstanceFilter {");
        stringBuffer.append("iid=" + this.iid);
        stringBuffer.append(",pid=" + this.pid);
        stringBuffer.append(",name=" + this.nameFilter);
        stringBuffer.append(",namespace=" + this.namespaceFilter);
        stringBuffer.append(",status=" + this.statusFilter);
        stringBuffer.append(",startedDate=" + this.startedDateFilter);
        stringBuffer.append(",lastActiveDate=" + this.lastActiveDateFilter);
        stringBuffer.append(",propertyValues=" + this.propertyValuesFilter);
        stringBuffer.append(",orders=" + this.orders);
        stringBuffer.append(",limit=" + this.limit);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusKeys {
        ACTIVE,
        SUSPENDED,
        ERROR,
        COMPLETED,
        TERMINATED,
        FAILED,
        FAULTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OrderKeys {
        PID,
        NAME,
        NAMESPACE,
        VERSION,
        STATUS,
        STARTED,
        LAST_ACTIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Criteria {
        IID{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                instanceFilter.iid = string3;
            }
        }
        ,
        PID{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                instanceFilter.pid = string3;
            }
        }
        ,
        NAME{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                instanceFilter.nameFilter = string3;
            }
        }
        ,
        NAMESPACE{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                instanceFilter.namespaceFilter = string3;
            }
        }
        ,
        STATUS{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                if (instanceFilter.statusFilter == null) {
                    instanceFilter.statusFilter = new ArrayList(5);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    instanceFilter.statusFilter.add(string4);
                }
            }
        }
        ,
        STARTED{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                if (instanceFilter.startedDateFilter == null) {
                    instanceFilter.startedDateFilter = new ArrayList();
                }
                instanceFilter.startedDateFilter.add(string2 + string3);
            }
        }
        ,
        LAST_ACTIVE{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                if (instanceFilter.lastActiveDateFilter == null) {
                    instanceFilter.lastActiveDateFilter = new ArrayList();
                }
                instanceFilter.lastActiveDateFilter.add(string2 + string3);
            }
        }
        ,
        PROPERTY{

            void process(InstanceFilter instanceFilter, String string, String string2, String string3) {
                if (instanceFilter.propertyValuesFilter == null) {
                    instanceFilter.propertyValuesFilter = new HashMap(5);
                }
                instanceFilter.propertyValuesFilter.put(string.substring(1, string.length()), string3);
            }
        };


        abstract void process(InstanceFilter var1, String var2, String var3, String var4);
    }
}

