/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.ode.utils.LoggingConnectionWrapper;

public class LoggingDataSourceWrapper
implements DataSource {
    private DataSource _wrapped;
    private Log _log;

    public LoggingDataSourceWrapper(DataSource dataSource, Log log) {
        this._wrapped = dataSource;
        this._log = log;
    }

    public Connection getConnection() throws SQLException {
        LoggingConnectionWrapper loggingConnectionWrapper = new LoggingConnectionWrapper(this._wrapped.getConnection(), this._log);
        if (this.shouldPrint()) {
            this.print("getConnection (tx=" + loggingConnectionWrapper.getTransactionIsolation() + ")");
        }
        return loggingConnectionWrapper;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        LoggingConnectionWrapper loggingConnectionWrapper = new LoggingConnectionWrapper(this._wrapped.getConnection(string, string2), this._log);
        if (this.shouldPrint()) {
            this.print("getConnection (tx=" + loggingConnectionWrapper.getTransactionIsolation() + ")");
        }
        return loggingConnectionWrapper;
    }

    public int getLoginTimeout() throws SQLException {
        return this._wrapped.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._wrapped.getLogWriter();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this._wrapped.setLoginTimeout(n);
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this._wrapped.setLogWriter(printWriter);
    }

    private boolean shouldPrint() {
        if (this._log != null) {
            return this._log.isDebugEnabled();
        }
        return true;
    }

    private void print(String string) {
        if (this._log != null) {
            this._log.debug((Object)string);
        } else {
            System.out.println(string);
        }
    }
}

