/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.ode.utils.NSContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NamespaceStack {
    private Frame _current = new Frame();

    public NamespaceStack() {
        this._current.declarePrefix("xmlns", "http://www.w3.org/2000/xmlns/");
        this._current.declarePrefix("xml", "http://www.w3.org/XML/1998/namespace");
        this._current.declarePrefix("", "");
    }

    public NSContext toNSContext() {
        NSContext nSContext = new NSContext();
        Frame frame = this._current;
        while (frame != null) {
            if (frame._bindings != null) {
                for (String string : frame._bindings.keySet()) {
                    if (nSContext.getNamespaceURI(string) != null) continue;
                    nSContext.register(string, frame._bindings.get(string));
                }
            }
            frame = frame._parent;
        }
        return nSContext;
    }

    public void pushNewContext() {
        this._current = new Frame(this._current);
    }

    public void pop() {
        if (this._current._parent == null) {
            throw new EmptyStackException();
        }
        this._current = this._current._parent;
    }

    public void declarePrefix(String string, String string2) {
        this._current.declarePrefix(string == null ? "" : string, string2 == null ? "" : string2);
    }

    public String getNamespaceUri(String string) {
        return this._current.getNamespaceURI(string == null ? "" : string);
    }

    public void startPrefixMappings(ContentHandler contentHandler) throws SAXException {
        this._current.startPrefixMappings(contentHandler);
    }

    public void endPrefixMappings(ContentHandler contentHandler) throws SAXException {
        this._current.endPrefixMappings(contentHandler);
    }

    public String allocatePrefix(String string, String string2) {
        String string3 = this.getPrefix(string2);
        if (string3 == null) {
            String string4 = this.getNamespaceUri(string = string == null ? "ns" : string);
            if (string4 == null) {
                this.declarePrefix(string, string2);
                string3 = string;
            } else if (string4.equals(string2)) {
                string3 = string;
            }
        }
        return string3;
    }

    public String getPrefix(String string) {
        return this.toNSContext().getPrefix(string);
    }

    public QName dereferenceQName(String string) {
        QName qName;
        if (string == null) {
            throw new IllegalArgumentException("Unable to dereference <null> as a QName.");
        }
        int n = string.indexOf(58);
        if (n == string.length() - 1 || n == 0) {
            throw new IllegalArgumentException("\"" + string + "\" is a malformed QName.");
        }
        if (n == -1) {
            qName = new QName(this.getNamespaceUri(""), string);
        } else {
            String string2 = this.getNamespaceUri(string.substring(0, n));
            if (string2 == null) {
                throw new IllegalArgumentException("No URI is bound to " + string.substring(0, n) + ".");
            }
            qName = new QName(string2, string.substring(n + 1));
        }
        return qName;
    }

    private class Frame {
        Frame _parent;
        HashMap<String, String> _bindings;

        Frame() {
        }

        Frame(Frame frame) {
            this._parent = frame;
        }

        void startPrefixMappings(ContentHandler contentHandler) throws SAXException {
            if (this._bindings != null) {
                for (String string : this._bindings.keySet()) {
                    contentHandler.startPrefixMapping(string, this._bindings.get(string));
                }
            }
        }

        void endPrefixMappings(ContentHandler contentHandler) throws SAXException {
            if (this._bindings != null) {
                Iterator<String> iterator = this._bindings.keySet().iterator();
                while (iterator.hasNext()) {
                    contentHandler.endPrefixMapping(iterator.next());
                }
            }
        }

        void declarePrefix(String string, String string2) {
            if (this._bindings == null) {
                this._bindings = new HashMap();
            }
            this._bindings.put(string, string2);
        }

        String getPrefix(String string) {
            return "";
        }

        String getNamespaceURI(String string) {
            String string2 = null;
            if (this._bindings != null) {
                string2 = this._bindings.get(string);
            }
            if (string2 == null) {
                string2 = this._parent == null ? null : this._parent.getNamespaceURI(string);
            }
            return string2;
        }
    }
}

