/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.ode.utils.Version;
import org.apache.ode.utils.cli.CommandLineMessages;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.Flag;
import org.apache.ode.utils.cli.Fragments;
import org.apache.ode.utils.cli.XorGroup;
import org.apache.ode.utils.fs.TempFileManager;
import org.apache.ode.utils.msg.MessageBundle;

public abstract class BaseCommandlineTool {
    public static final int TERSE = 0;
    public static final int VERBOSE = 1;
    public static final int EFFUSIVE = 2;
    private static boolean _tempFileManagerRegistered = false;
    private static Class CLAZZ = BaseCommandlineTool.class;
    private static final String LOGGING_PATTERN = "%p - %d{ISO8601} - <%c> %m%n";
    protected static final Flag HELP_FLAG = new Flag("h", "print usage and help to the console and exit.", false);
    protected static final Fragments HELP = new Fragments(new CommandlineFragment[]{HELP_FLAG});
    protected static final Flag QUIET_F = new Flag("q", "only produce error output in the event of an error.", false);
    protected static final Flag VERBOSE_F = new Flag("v", "produce verbose (INFO-level) logging output.", false);
    protected static final Flag VERYVERBOSE_F = new Flag("vv", "product effusive (DEBUG-level) logging output", false);
    protected static final XorGroup LOGGING = new XorGroup("set logging output verbosity from quiet (-q), to verbose (-v), to effusive (-vv).", true);
    private static final CommandLineMessages __msgs;

    public static void outputHeader() {
        if (QUIET_F.isSet()) {
            return;
        }
        System.out.println(__msgs.msgCliHeader(BaseCommandlineTool.getProgramName(), Version.getVersionName(), Version.getBuildDate()));
    }

    protected static void initLogging(int n) {
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new SimpleLayout());
        consoleAppender.setName("stderr appender");
        consoleAppender.setWriter((Writer)new PrintWriter(System.err));
        consoleAppender.setLayout((Layout)new PatternLayout(LOGGING_PATTERN));
        BaseCommandlineTool.initialize((AppenderSkeleton)consoleAppender, n);
        BasicConfigurator.configure((Appender)consoleAppender);
        Logger.getRootLogger().addAppender((Appender)consoleAppender);
    }

    protected static void initLogFile() throws IOException {
        BaseCommandlineTool.initLogFile(BaseCommandlineTool.getLevel());
    }

    protected static void initLogFile(int n) throws IOException {
        FileAppender fileAppender = new FileAppender((Layout)new PatternLayout(LOGGING_PATTERN), System.getProperty("ode.home") + "/logs/ode.log");
        fileAppender.setName("file appender");
        BaseCommandlineTool.initialize((AppenderSkeleton)fileAppender, n);
        BasicConfigurator.configure((Appender)fileAppender);
        Logger.getRootLogger().addAppender((Appender)fileAppender);
    }

    private static void initialize(AppenderSkeleton appenderSkeleton, int n) {
        switch (n) {
            case 2: {
                appenderSkeleton.setThreshold((Priority)Level.DEBUG);
                break;
            }
            case 1: {
                appenderSkeleton.setThreshold((Priority)Level.INFO);
                break;
            }
            default: {
                appenderSkeleton.setThreshold((Priority)Level.WARN);
            }
        }
    }

    protected static void setClazz(Class clazz) {
        CLAZZ = clazz;
    }

    protected static String getProgramName() {
        return "java " + CLAZZ.getName();
    }

    protected static void initLogging() {
        BaseCommandlineTool.initLogging(BaseCommandlineTool.getLevel());
    }

    private static int getLevel() {
        if (QUIET_F.isSet()) {
            return 0;
        }
        if (VERBOSE_F.isSet()) {
            return 1;
        }
        if (VERYVERBOSE_F.isSet()) {
            return 2;
        }
        return -1;
    }

    protected static final synchronized void registerTempFileManager() {
        if (!_tempFileManagerRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    TempFileManager.cleanup();
                }
            });
        }
    }

    protected static void consoleErr(String string) {
        String string2 = BaseCommandlineTool.getProgramName();
        System.err.println(string2 + ": " + string);
    }

    static {
        LOGGING.addFragment(QUIET_F);
        LOGGING.addFragment(VERBOSE_F);
        LOGGING.addFragment(VERYVERBOSE_F);
        __msgs = MessageBundle.getMessages(CommandLineMessages.class);
    }
}

