/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.Collections;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiArgument
implements CommandlineFragment {
    private String _argName;
    private String _description;
    private String[] _values;
    private boolean _isOptional;

    public MultiArgument(String string, String string2, boolean bl) {
        this._argName = string;
        this._description = string2;
        this._isOptional = bl;
    }

    @Override
    public void reset() {
        this._values = null;
    }

    @Override
    public List<String> consume(List<String> list) throws CommandlineSyntaxException {
        if (list.size() == 0 && !this._isOptional) {
            throw new CommandlineSyntaxException("The " + this._argName + " argument is required.");
        }
        if (list.size() != 0) {
            this._values = list.toArray(new String[list.size()]);
            for (int i = 0; i < this._values.length; ++i) {
                if (!this._values[i].startsWith("-")) continue;
                throw new CommandlineSyntaxException("The flag " + this._values[i] + " was found where an argument <" + this._argName + "> was expected.");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    public boolean isSet() {
        return this._values != null;
    }

    public String[] getValues() {
        return this._values;
    }

    @Override
    public String getUsage() {
        return "<" + this._argName + "_1> ... <" + this._argName + "_n>";
    }

    @Override
    public String getDescription() {
        return this._description;
    }
}

