/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.ls.LSInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelImpl
implements SchemaModel {
    private XSModel _model;

    private SchemaModelImpl(XSModel xSModel) {
        if (xSModel == null) {
            throw new NullPointerException("Null model.");
        }
        this._model = xSModel;
    }

    public static final SchemaModel newModel(Map<URI, byte[]> map) {
        XMLSchemaLoader xMLSchemaLoader = new XMLSchemaLoader();
        InternalSchemaResolver internalSchemaResolver = new InternalSchemaResolver();
        xMLSchemaLoader.setEntityResolver((XMLEntityResolver)internalSchemaResolver);
        final String[] stringArray = new String[map.size()];
        final byte[][] byArrayArray = new byte[map.size()][];
        int n = 0;
        for (Map.Entry<URI, byte[]> entry : map.entrySet()) {
            stringArray[n] = entry.getKey().toASCIIString();
            byArrayArray[n] = entry.getValue();
            internalSchemaResolver.put(entry.getKey(), entry.getValue());
            ++n;
        }
        LSInputList lSInputList = new LSInputList(){

            public LSInput item(int n) {
                DOMInputImpl dOMInputImpl = new DOMInputImpl();
                dOMInputImpl.setSystemId(stringArray[n]);
                dOMInputImpl.setByteStream((InputStream)new ByteArrayInputStream(byArrayArray[n]));
                return dOMInputImpl;
            }

            public int getLength() {
                return stringArray.length;
            }
        };
        return new SchemaModelImpl(xMLSchemaLoader.loadInputList(lSInputList));
    }

    @Override
    public boolean isCompatible(QName qName, QName qName2) {
        XSTypeDefinition xSTypeDefinition;
        XSTypeDefinition xSTypeDefinition2;
        if (this.knowsElementType(qName)) {
            xSTypeDefinition2 = this._model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI()).getTypeDefinition();
        } else if (this.knowsSchemaType(qName)) {
            xSTypeDefinition2 = this._model.getTypeDefinition(qName.getLocalPart(), qName.getNamespaceURI());
        } else {
            throw new IllegalArgumentException("unknown schema type: " + qName);
        }
        if (this.knowsElementType(qName2)) {
            xSTypeDefinition = this._model.getElementDeclaration(qName2.getLocalPart(), qName2.getNamespaceURI()).getTypeDefinition();
        } else if (this.knowsSchemaType(qName2)) {
            xSTypeDefinition = this._model.getTypeDefinition(qName2.getLocalPart(), qName2.getNamespaceURI());
        } else {
            throw new IllegalArgumentException("unknown schema type: " + qName2);
        }
        return xSTypeDefinition2.derivedFromType(xSTypeDefinition, (short)0) || xSTypeDefinition.derivedFromType(xSTypeDefinition2, (short)0);
    }

    @Override
    public boolean isSimpleType(QName qName) {
        if (qName == null) {
            throw new NullPointerException("Null type argument!");
        }
        XSTypeDefinition xSTypeDefinition = this._model.getTypeDefinition(qName.getLocalPart(), qName.getNamespaceURI());
        return xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 16;
    }

    @Override
    public boolean knowsElementType(QName qName) {
        if (qName == null) {
            throw new NullPointerException("Null type argument!");
        }
        return this._model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI()) != null;
    }

    @Override
    public boolean knowsSchemaType(QName qName) {
        if (qName == null) {
            throw new NullPointerException("Null type argument!");
        }
        return this._model.getTypeDefinition(qName.getLocalPart(), qName.getNamespaceURI()) != null;
    }

    public static class InternalSchemaResolver
    implements XMLEntityResolver {
        private Map<String, byte[]> _schemas = new HashMap<String, byte[]>();

        public void put(URI uRI, byte[] byArray) {
            this._schemas.put(uRI.toASCIIString(), byArray);
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
            XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
            String string = "";
            if (xMLResourceIdentifier.getNamespace() != null && this._schemas.get(xMLResourceIdentifier.getNamespace()) != null) {
                string = xMLResourceIdentifier.getNamespace();
            } else if (xMLResourceIdentifier.getLiteralSystemId() != null && this._schemas.get(xMLResourceIdentifier.getLiteralSystemId()) != null) {
                string = xMLResourceIdentifier.getLiteralSystemId();
            }
            xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(this._schemas.get(string)));
            return xMLInputSource;
        }
    }
}

