/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsl;

import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.ode.utils.xsl.XslTransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XslTransformHandler {
    private static XslTransformHandler __singleton;
    private TransformerFactory _transformerFactory = null;
    private final HashMap<URI, Templates> _templateCache = new HashMap();

    public static synchronized XslTransformHandler getInstance() {
        if (__singleton == null) {
            __singleton = new XslTransformHandler();
        }
        return __singleton;
    }

    private XslTransformHandler() {
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this._transformerFactory = transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXSLSheet(URI uRI, String string, URIResolver uRIResolver) {
        Templates templates;
        try {
            this._transformerFactory.setURIResolver(uRIResolver);
            templates = this._transformerFactory.newTemplates(new StreamSource(new StringReader(string)));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XslTransformException(transformerConfigurationException);
        }
        HashMap<URI, Templates> hashMap = this._templateCache;
        synchronized (hashMap) {
            this._templateCache.put(uRI, templates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheXSLSheet(URI uRI, String string, URIResolver uRIResolver) {
        Templates templates;
        HashMap<URI, Templates> hashMap = this._templateCache;
        synchronized (hashMap) {
            templates = this._templateCache.get(uRI);
        }
        if (templates == null) {
            this.parseXSLSheet(uRI, string, uRIResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(URI uRI, Source source, Result result, Map<QName, Object> map, URIResolver uRIResolver) {
        Templates templates;
        Object object = this._templateCache;
        synchronized (object) {
            templates = this._templateCache.get(uRI);
        }
        if (templates == null) {
            throw new XslTransformException("XSL sheet" + uRI + " has not been parsed before transformation!");
        }
        try {
            object = templates.newTransformer();
            ((Transformer)object).setURIResolver(uRIResolver);
            if (map != null) {
                for (Map.Entry<QName, Object> entry : map.entrySet()) {
                    ((Transformer)object).setParameter(entry.getKey().getLocalPart(), entry.getValue());
                }
            }
            ((Transformer)object).transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XslTransformException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XslTransformException("XSL Transformation failed!", transformerException);
        }
    }

    public void setErrorListener(ErrorListener errorListener) {
        this._transformerFactory.setErrorListener(errorListener);
    }
}

