/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.ode.utils.LoggingStatementWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingConnectionWrapper
implements Connection {
    private Connection _conn;
    private Log _log;

    public LoggingConnectionWrapper(Connection connection) {
        this._conn = connection;
    }

    public LoggingConnectionWrapper(Connection connection, Log log) {
        this._conn = connection;
        this._log = log;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._conn.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (this.shouldPrint()) {
            this.print("close");
        }
        this._conn.close();
    }

    @Override
    public void commit() throws SQLException {
        if (this.shouldPrint()) {
            this.print("commit");
        }
        this._conn.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this._conn.createStatement();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this._conn.createStatement(n, n2);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this._conn.createStatement(n, n2, n3);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._conn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this._conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this._conn.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this._conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._conn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this._conn.isReadOnly();
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this._conn.nativeSQL(string);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareCall: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareCall(string), this._log);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareCall: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareCall(string, n, n2), this._log);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareCall: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareCall(string, n, n2, n3), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(string), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(string, n), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(string, nArray), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(string, stringArray), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(string, n, n2), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + string);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(string, n, n2, n3), this._log);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        if (this.shouldPrint()) {
            this.print("rollback");
        }
        this._conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.shouldPrint()) {
            this.print("rollback");
        }
        this._conn.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this._conn.setAutoCommit(bl);
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this._conn.setCatalog(string);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this._conn.setHoldability(n);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this._conn.setReadOnly(bl);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return this._conn.setSavepoint(string);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (this.shouldPrint()) {
            this.print("Setting isolation level to " + n);
        }
        this._conn.setTransactionIsolation(n);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this._conn.setTypeMap(map);
    }

    private boolean shouldPrint() {
        if (this._log != null) {
            return this._log.isDebugEnabled();
        }
        return true;
    }

    private void print(String string) {
        if (this._log != null) {
            this._log.debug((Object)string);
        } else {
            System.out.println(string);
        }
    }
}

