/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 16384;

    public static byte[] read(URL uRL) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        StreamUtils.copy((OutputStream)byteArrayOutputStream, uRL);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        StreamUtils.copy((OutputStream)byteArrayOutputStream, inputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copy(OutputStream outputStream, InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void copy(Writer writer, Reader reader, int n) throws IOException {
        int n2;
        char[] cArray = new char[n];
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
        }
    }

    public static void copy(OutputStream outputStream, InputStream inputStream) throws IOException {
        StreamUtils.copy(outputStream, inputStream, 16384);
    }

    public static void copy(OutputStream outputStream, URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        StreamUtils.copy(outputStream, inputStream);
        inputStream.close();
    }

    public static void write(OutputStream outputStream, Serializable serializable) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
    }

    public static Object readObj(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return objectInputStream.readObject();
    }

    public static void extractJar(File file, InputStream inputStream) throws IOException {
        JarEntry jarEntry;
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            File file2 = new File(file, jarEntry.getName());
            if (jarEntry.isDirectory()) {
                file2.mkdirs();
            } else {
                file2.getParentFile().mkdirs();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                StreamUtils.copy((OutputStream)bufferedOutputStream, jarInputStream);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            jarInputStream.closeEntry();
        }
    }
}

