/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ode.utils.SystemConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLParserUtils {
    public static final String NAMESPACES_SAXF = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_SAXF = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_V_XERCESF = "http://apache.org/xml/features/validation/schema";
    private static final String XERCES_P_ROOT = "http://apache.org/xml/properties/schema/";
    private static final String EXTERNAL_SCHEMA_LOC_XERCESP = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String EXTERNAL_SCHEMA_NNS_LOC_XERCESP = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    public static SAXParserFactory getSAXParserFactory() {
        return new SAXParserFactoryImpl();
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return new DocumentBuilderFactoryImpl();
    }

    public static void setNamespaces(XMLReader xMLReader) {
        try {
            xMLReader.setFeature(NAMESPACES_SAXF, true);
        }
        catch (SAXException sAXException) {
            throw new SystemConfigurationException(sAXException);
        }
    }

    public static XMLReader getXMLReader() {
        return new SAXParser();
    }

    public static DOMParser getDOMParser() {
        return new DOMParser();
    }

    public static void setExternalSchemaURL(XMLReader xMLReader, String string, String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        xMLReader.setFeature(NAMESPACES_SAXF, true);
        if (string != null && string.length() > 0) {
            xMLReader.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, string + " " + string2);
        } else {
            xMLReader.setProperty(EXTERNAL_SCHEMA_NNS_LOC_XERCESP, string2);
        }
        xMLReader.setFeature(VALIDATION_SAXF, true);
        xMLReader.setFeature(SCHEMA_V_XERCESF, true);
    }

    public static void setExternalSchemaURL(DOMParser dOMParser, String string, String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        dOMParser.setFeature(VALIDATION_SAXF, true);
        dOMParser.setFeature(SCHEMA_V_XERCESF, true);
        if (string != null && string.length() > 0) {
            dOMParser.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, (Object)(string + " " + string2));
        } else {
            dOMParser.setProperty(EXTERNAL_SCHEMA_NNS_LOC_XERCESP, (Object)string2);
        }
    }

    public static void addExternalSchemaURL(XMLReader xMLReader, String string, String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        Object object;
        CharSequence charSequence;
        xMLReader.setFeature(VALIDATION_SAXF, true);
        xMLReader.setFeature(SCHEMA_V_XERCESF, true);
        if (string == null || string.length() == 0) {
            XMLParserUtils.setExternalSchemaURL(xMLReader, string, string2);
            return;
        }
        String string3 = (String)xMLReader.getProperty(EXTERNAL_SCHEMA_LOC_XERCESP);
        if (string3 == null) {
            XMLParserUtils.setExternalSchemaURL(xMLReader, string, string2);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        HashMap<CharSequence, String> hashMap = new HashMap<CharSequence, String>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new RuntimeException("Property has been misconfigured; expected an even number of tokens.  Value was: " + string3);
            }
            object = stringTokenizer.nextToken();
            hashMap.put(charSequence, (String)object);
        }
        hashMap.put(string, string2);
        charSequence = new StringBuffer();
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            String string4 = (String)object.next();
            ((StringBuffer)charSequence).append(string4);
            ((StringBuffer)charSequence).append(' ');
            ((StringBuffer)charSequence).append((String)hashMap.get(string4));
            if (!object.hasNext()) continue;
            ((StringBuffer)charSequence).append(' ');
        }
        xMLReader.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, ((StringBuffer)charSequence).toString());
        xMLReader.setFeature(VALIDATION_SAXF, true);
        xMLReader.setFeature(SCHEMA_V_XERCESF, true);
    }

    public static void addExternalSchemaURL(DOMParser dOMParser, String string, String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        Object object;
        CharSequence charSequence;
        dOMParser.setFeature(VALIDATION_SAXF, true);
        dOMParser.setFeature(SCHEMA_V_XERCESF, true);
        if (string == null || string.length() == 0) {
            XMLParserUtils.setExternalSchemaURL(dOMParser, string, string2);
            return;
        }
        String string3 = (String)dOMParser.getProperty(EXTERNAL_SCHEMA_LOC_XERCESP);
        if (string3 == null) {
            XMLParserUtils.setExternalSchemaURL(dOMParser, string, string2);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        HashMap<CharSequence, String> hashMap = new HashMap<CharSequence, String>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new RuntimeException("Property has been misconfigured; expected an even number of tokens.  Value was: " + string3);
            }
            object = stringTokenizer.nextToken();
            hashMap.put(charSequence, (String)object);
        }
        hashMap.put(string, string2);
        charSequence = new StringBuffer();
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            String string4 = (String)object.next();
            ((StringBuffer)charSequence).append(string4);
            ((StringBuffer)charSequence).append(' ');
            ((StringBuffer)charSequence).append((String)hashMap.get(string4));
            if (!object.hasNext()) continue;
            ((StringBuffer)charSequence).append(' ');
        }
        dOMParser.setProperty(EXTERNAL_SCHEMA_LOC_XERCESP, (Object)((StringBuffer)charSequence).toString());
        dOMParser.setFeature(VALIDATION_SAXF, true);
        dOMParser.setFeature(SCHEMA_V_XERCESF, true);
    }

    public static ContentHandler getXercesSerializer(OutputStream outputStream) {
        XMLSerializer xMLSerializer = new XMLSerializer();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setPreserveSpace(true);
        outputFormat.setOmitDocumentType(true);
        xMLSerializer.setOutputFormat(outputFormat);
        xMLSerializer.setOutputByteStream(outputStream);
        return xMLSerializer;
    }
}

