/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import javax.xml.namespace.QName;
import org.apache.ode.utils.ISO8601DateParser;

public class XSTypes {
    public static Object toJavaObject(QName qName, String string) {
        String string2 = null;
        try {
            if (XSTypes.isDecimal(qName)) {
                string2 = "number";
                return Long.valueOf(string);
            }
            if (XSTypes.isFloat(qName)) {
                string2 = "double";
                return Double.valueOf(string);
            }
            if (XSTypes.isBoolean(qName)) {
                string2 = "boolean";
                return Boolean.valueOf(string);
            }
            if (XSTypes.isFloat(qName)) {
                string2 = "double";
                return Double.valueOf(string);
            }
            if (XSTypes.isDate(qName)) {
                string2 = "date";
                return ISO8601DateParser.parseCal(string);
            }
            if (XSTypes.isString(qName)) {
                string2 = "string";
                return string;
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("The type " + string2 + " has been detected using the XSD type " + qName + " but the parsing failed! The provided value is probably not of the right type:" + exception.toString());
        }
        throw new IllegalArgumentException("Couldn't find java type for " + qName);
    }

    public static boolean isNumber(QName qName) {
        try {
            DECIMAL.valueOf(qName.getLocalPart().toUpperCase());
            FLOAT.valueOf(qName.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isDate(QName qName) {
        try {
            DATEBASE.valueOf(qName.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isString(QName qName) {
        try {
            STRING.valueOf(qName.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isDecimal(QName qName) {
        try {
            DECIMAL.valueOf(qName.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isFloat(QName qName) {
        try {
            FLOAT.valueOf(qName.getLocalPart().toUpperCase());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isBoolean(QName qName) {
        return "boolean".equals(qName.getLocalPart());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DATEBASE {
        DATETIME,
        DATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum STRING {
        STRING,
        NORMALIZEDSTRING,
        TOKEN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FLOAT {
        FLOAT,
        DOUBLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DECIMAL {
        DECIMAL,
        INTEGER,
        NONPOSITIVEINTEGER,
        LONG,
        NONNEGATIVEINTEGER,
        NEGATIVEINTEGER,
        INT,
        UNSIGNEDLONG,
        POSITIVEINTEGER,
        SHORT,
        BYTE,
        UNSIGNEDINT,
        UNSIGNEDSHORT,
        UNSIGNEDBYTE;

    }
}

