/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPartnerLink
extends OBase {
    static final long serialVersionUID = -1L;
    public String name;
    public OScope declaringScope;
    public QName partnerLinkType;
    public String partnerRoleName;
    public String myRoleName;
    public PortType myRolePortType;
    public PortType partnerRolePortType;
    public boolean initializePartnerRole;
    private final HashMap<String, Set<OScope.CorrelationSet>> _nonIntitiatingCorrelationSets = new HashMap();
    private final HashSet<String> _createInstanceOperations = new HashSet();

    public OPartnerLink(OProcess oProcess) {
        super(oProcess);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasMyRole() {
        return this.myRolePortType != null;
    }

    public boolean hasPartnerRole() {
        return this.partnerRolePortType != null;
    }

    public boolean isCreateInstanceOperation(Operation operation) {
        return this._createInstanceOperations.contains(operation.getName());
    }

    public void addCreateInstanceOperation(Operation operation) {
        this._createInstanceOperations.add(operation.getName());
    }

    public void addCorrelationSetForOperation(Operation operation, OScope.CorrelationSet correlationSet) {
        Set<OScope.CorrelationSet> set = this._nonIntitiatingCorrelationSets.get(operation.getName());
        if (set == null) {
            set = new HashSet<OScope.CorrelationSet>();
            this._nonIntitiatingCorrelationSets.put(operation.getName(), set);
        }
        set.add(correlationSet);
    }

    public Set<OScope.CorrelationSet> getCorrelationSetsForOperation(Operation operation) {
        Set<OScope.CorrelationSet> set = this._nonIntitiatingCorrelationSets.get(operation.getName());
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }

    public Operation getMyRoleOperation(String string) {
        for (Operation operation : this.myRolePortType.getOperations()) {
            if (!operation.getName().equals(string)) continue;
            return operation;
        }
        return null;
    }

    public Operation getPartnerRoleOperation(String string) {
        for (Operation operation : this.partnerRolePortType.getOperations()) {
            if (!operation.getName().equals(string)) continue;
            return operation;
        }
        return null;
    }
}

