/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.tools;

import org.apache.ode.tools.CommandContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CommandContextErrorHandler
implements ErrorHandler {
    private CommandContext _cc;
    private boolean _err;

    public CommandContextErrorHandler(CommandContext commandContext) {
        this._cc = commandContext;
        this._err = false;
    }

    public boolean hadError() {
        return this._err;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._cc.warn(this.formatMessage(sAXParseException));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this._err = true;
        this._cc.errln(this.formatMessage(sAXParseException));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._err = true;
        this._cc.error(this.formatMessage(sAXParseException), sAXParseException);
        throw sAXParseException;
    }

    private String formatMessage(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (sAXParseException.getSystemId() == null) {
            stringBuffer.append("<<null>>");
        } else {
            stringBuffer.append(sAXParseException.getSystemId());
        }
        stringBuffer.append(" ");
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        stringBuffer.append("] ");
        stringBuffer.append(sAXParseException.getMessage());
        return stringBuffer.toString();
    }
}

