/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ode.bpel.common.Messages;
import org.apache.ode.utils.ArrayUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Filter<FKEY extends Enum>
implements Serializable {
    private static final long serialVersionUID = 9999L;
    protected static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static final Pattern __comparatorPattern = Pattern.compile("([^=<> ]*) *(<=|>=|<|>|=) *([^=<> ]*)");
    protected Map<FKEY, Restriction<String>> _criteria = new HashMap<FKEY, Restriction<String>>();

    public void init(String string) {
        if (string != null) {
            Matcher matcher = __comparatorPattern.matcher(string);
            while (matcher.find()) {
                FKEY FKEY;
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                try {
                    FKEY = this.parseKey(string2.toUpperCase().replaceAll("-", "_"));
                }
                catch (Exception exception) {
                    String string5 = __msgs.msgUnrecognizedFilterKey(string2, this.getFilterKeysStr());
                    throw new IllegalArgumentException(string5, exception);
                }
                Restriction<String> restriction = new Restriction<String>(string2, string3, string4);
                this._criteria.put(FKEY, restriction);
                this.process(FKEY, restriction);
            }
        }
    }

    public static String getDateWithoutOp(String string) {
        if (string != null) {
            if (string.startsWith("=")) {
                return string.substring(1, string.length());
            }
            if (string.startsWith("<=")) {
                return string.substring(2, string.length());
            }
            if (string.startsWith(">=")) {
                return string.substring(2, string.length());
            }
            if (string.startsWith("<")) {
                return string.substring(1, string.length());
            }
            if (string.startsWith(">")) {
                return string.substring(1, string.length());
            }
        }
        return null;
    }

    protected abstract FKEY parseKey(String var1);

    protected abstract FKEY[] getFilterKeys();

    protected abstract void process(FKEY var1, Restriction<String> var2);

    private Collection<String> getFilterKeysStr() {
        return CollectionsX.transform(new ArrayList(), (Collection)ArrayUtils.makeCollection(ArrayList.class, (Object[])this.getFilterKeys()), (UnaryFunction)new UnaryFunction<FKEY, String>(){

            public String apply(FKEY FKEY) {
                return ((Enum)FKEY).name();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Restriction<V> {
        public final String originalKey;
        public final String op;
        public final V value;

        public Restriction(String string, String string2, V v) {
            this.originalKey = string;
            this.op = string2;
            this.value = v;
        }
    }
}

