/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OExpressionLanguage;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.bpel.o.OXslSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OProcess
extends OBase {
    public static int instanceCount = 0;
    static final long serialVersionUID = -1L;
    public String guid;
    public final String version;
    public OConstants constants;
    public String uuid;
    public String targetNamespace;
    public String processName;
    public OScope procesScope;
    public final Set<OPartnerLink> allPartnerLinks = new HashSet<OPartnerLink>();
    public final List<OProperty> properties = new ArrayList<OProperty>();
    public Date compileDate;
    int _childIdCounter = 0;
    List<OBase> _children = new ArrayList<OBase>();
    public final HashSet<OExpressionLanguage> expressionLanguages = new HashSet();
    public final HashMap<QName, OMessageVarType> messageTypes = new HashMap();
    public final HashMap<QName, OElementVarType> elementTypes = new HashMap();
    public final HashMap<QName, OXsdTypeVarType> xsdTypes = new HashMap();
    public final HashMap<URI, OXslSheet> xslSheets = new HashMap();

    public OProcess(String string) {
        super(null);
        this.version = string;
        ++instanceCount;
    }

    public OBase getChild(int n) {
        for (int i = this._children.size() - 1; i >= 0; --i) {
            OBase oBase = this._children.get(i);
            if (oBase.getId() != n) continue;
            return oBase;
        }
        return null;
    }

    public List<OBase> getChildren() {
        return this._children;
    }

    public OScope getScope(String string) {
        throw new UnsupportedOperationException();
    }

    public Set<OPartnerLink> getAllPartnerLinks() {
        return Collections.unmodifiableSet(this.allPartnerLinks);
    }

    public OPartnerLink getPartnerLink(String string) {
        for (OPartnerLink oPartnerLink : this.allPartnerLinks) {
            if (!oPartnerLink.getName().equals(string)) continue;
            return oPartnerLink;
        }
        return null;
    }

    public String getName() {
        return this.processName;
    }

    public Collection getExpressionLanguages() {
        throw new UnsupportedOperationException();
    }

    public List<String> getCorrelators() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OPartnerLink oPartnerLink : this.getAllPartnerLinks()) {
            if (!oPartnerLink.hasMyRole()) continue;
            for (Operation operation : oPartnerLink.myRolePortType.getOperations()) {
                arrayList.add(oPartnerLink.getId() + "." + operation.getName());
            }
        }
        return arrayList;
    }

    public QName getQName() {
        return new QName(this.targetNamespace, this.processName);
    }

    protected void finalize() throws Throwable {
        --instanceCount;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ++instanceCount;
    }

    public static class OPropertyAlias
    extends OBase {
        static final long serialVersionUID = -1L;
        public OVarType varType;
        public OMessageVarType.Part part;
        public OExpression location;

        public OPropertyAlias(OProcess oProcess) {
            super(oProcess);
        }

        public String toString() {
            return "{OPropertyAlias " + this.getDescription() + "}";
        }

        public String getDescription() {
            StringBuffer stringBuffer = new StringBuffer(this.varType.toString());
            stringBuffer.append('[');
            stringBuffer.append(this.part != null ? this.part.name : "");
            if (this.location != null) {
                stringBuffer.append("][");
                stringBuffer.append(this.location.toString());
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }

    public static class OProperty
    extends OBase {
        static final long serialVersionUID = -1L;
        public final List<OPropertyAlias> aliases = new ArrayList<OPropertyAlias>();
        public QName name;

        public OProperty(OProcess oProcess) {
            super(oProcess);
        }

        public OPropertyAlias getAlias(OVarType oVarType) {
            for (OPropertyAlias oPropertyAlias : this.aliases) {
                if (!oPropertyAlias.varType.equals(oVarType)) continue;
                return oPropertyAlias;
            }
            return null;
        }

        public String toString() {
            return "{OProperty " + this.name + "}";
        }
    }
}

