/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.xml.sax.InputSource;

public class XPathEvaluator
implements XPath {
    private Configuration config;
    private NodeInfo contextNode = null;
    private StandaloneContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
        this(new Configuration());
    }

    public XPathEvaluator(Configuration configuration) {
        this.config = configuration;
        this.staticContext = new StandaloneContext(configuration);
    }

    public XPathEvaluator(Source source) throws XPathException {
        this.config = source instanceof NodeInfo ? ((NodeInfo)source).getDocumentRoot().getConfiguration() : new Configuration();
        this.staticContext = new StandaloneContext(this.config);
        this.setSource(source);
    }

    public void setStripSpace(boolean bl) {
        this.stripSpace = bl;
    }

    public NodeInfo setSource(Source source) throws XPathException {
        AllElementStripper allElementStripper = null;
        if (this.stripSpace) {
            allElementStripper = AllElementStripper.getInstance();
        }
        this.contextNode = Builder.build((Source)source, (Stripper)allElementStripper, (Configuration)this.config);
        return this.contextNode;
    }

    public void setStaticContext(StandaloneContext standaloneContext) {
        this.staticContext = standaloneContext;
    }

    public StandaloneContext getStaticContext() {
        return this.staticContext;
    }

    public XPathExpressionImpl createExpression(String string) throws XPathException {
        Expression expression = ExpressionTool.make((String)string, (StaticContext)this.staticContext, (int)0, (int)-1, (int)1);
        expression = expression.typeCheck((StaticContext)this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots((Expression)expression, (int)0, (SlotManager)slotManager);
        XPathExpressionImpl xPathExpressionImpl = new XPathExpressionImpl(expression, this.config);
        xPathExpressionImpl.setStackFrameMap(slotManager);
        if (this.contextNode != null) {
            xPathExpressionImpl.setContextNode(this.contextNode);
        }
        return xPathExpressionImpl;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        this.contextNode = nodeInfo;
    }

    public List evaluate(String string) throws XPathException {
        Expression expression = ExpressionTool.make((String)string, (StaticContext)this.staticContext, (int)0, (int)-1, (int)1);
        expression = expression.typeCheck((StaticContext)this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots((Expression)expression, (int)0, (SlotManager)slotManager);
        XPathContextMajor xPathContextMajor = new XPathContextMajor((Item)this.contextNode, this.staticContext.getConfiguration());
        xPathContextMajor.openStackFrame(slotManager);
        SequenceIterator sequenceIterator = expression.iterate((XPathContext)xPathContextMajor);
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(Value.convert((Item)item));
        }
        return arrayList;
    }

    public void reset() {
        this.config = null;
        this.contextNode = null;
        this.stripSpace = false;
        this.staticContext = new StandaloneContext(this.config);
    }

    public void setBackwardsCompatible(boolean bl) {
        this.staticContext.setBackwardsCompatibilityMode(true);
    }

    public boolean isBackwardsCompatible() {
        return this.staticContext.isInBackwardsCompatibleMode();
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.staticContext.setXPathVariableResolver(xPathVariableResolver);
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.staticContext.getXPathVariableResolver();
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.staticContext.setXPathFunctionResolver(xPathFunctionResolver);
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.staticContext.getXPathFunctionResolver();
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.staticContext.setNamespaceContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.staticContext.getNamespaceContext();
    }

    public void importSchema(Source source) throws SchemaException {
        this.staticContext.importSchema(source);
    }

    public XPathExpression compile(String string) throws XPathExpressionException {
        try {
            return this.createExpression(string);
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    public Object evaluate(String string, Object object, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object, qName);
    }

    public String evaluate(String string, Object object) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object);
    }

    public Object evaluate(String string, InputSource inputSource, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource, qName);
    }

    public String evaluate(String string, InputSource inputSource) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource);
    }

    public Object evaluateSingle(String string) throws XPathException {
        Expression expression = ExpressionTool.make((String)string, (StaticContext)this.staticContext, (int)0, (int)-1, (int)1);
        expression = expression.typeCheck((StaticContext)this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots((Expression)expression, (int)0, (SlotManager)slotManager);
        XPathContextMajor xPathContextMajor = new XPathContextMajor((Item)this.contextNode, this.staticContext.getConfiguration());
        xPathContextMajor.openStackFrame(slotManager);
        SequenceIterator sequenceIterator = expression.iterate((XPathContext)xPathContextMajor);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return Value.convert((Item)item);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("format: java XPathEvaluator source.xml \"expression\"");
            return;
        }
        XPathEvaluator xPathEvaluator = new XPathEvaluator(new StreamSource(new File(stringArray[0])));
        List list = xPathEvaluator.evaluate(stringArray[1]);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            System.err.println(e);
        }
    }
}

