/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.ReplyGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.ReplyActivity;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OReply;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.msg.MessageBundle;

class ReplyGenerator
extends DefaultActivityGenerator {
    private static final CommonCompilationMessages _cmsgsGeneral = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private static final ReplyGeneratorMessages __cmsgsLocal = (ReplyGeneratorMessages)MessageBundle.getMessages(ReplyGeneratorMessages.class);

    ReplyGenerator() {
    }

    public OActivity newInstance(Activity activity) {
        return new OReply(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity oActivity, Activity activity) {
        ReplyActivity replyActivity = (ReplyActivity)activity;
        OReply oReply = (OReply)oActivity;
        oReply.isFaultReply = replyActivity.getFaultName() != null;
        oReply.partnerLink = this._context.resolvePartnerLink(replyActivity.getPartnerLink());
        oReply.messageExchangeId = replyActivity.getMessageExchangeId();
        if (replyActivity.getVariable() != null) {
            oReply.variable = this._context.resolveVariable(replyActivity.getVariable());
            if (!(oReply.variable.type instanceof OMessageVarType)) {
                throw new CompilationException(_cmsgsGeneral.errMessageVariableRequired(oReply.variable.name));
            }
        }
        if (oReply.partnerLink.myRolePortType == null) {
            throw new CompilationException(_cmsgsGeneral.errPartnerLinkDoesNotDeclareMyRole(oReply.partnerLink.getName()));
        }
        if (replyActivity.getPortType() != null && !oReply.partnerLink.myRolePortType.getQName().equals(replyActivity.getPortType())) {
            throw new CompilationException(_cmsgsGeneral.errPortTypeMismatch(replyActivity.getPortType(), oReply.partnerLink.myRolePortType.getQName()));
        }
        oReply.operation = this._context.resolveMyRoleOperation(oReply.partnerLink, replyActivity.getOperation());
        if (oReply.operation.getOutput() == null) {
            throw new CompilationException(_cmsgsGeneral.errTwoWayOperationExpected(oReply.operation.getName()));
        }
        if (oReply.isFaultReply) {
            Object object = null;
            if (replyActivity.getFaultName().getNamespaceURI().equals(oReply.partnerLink.myRolePortType.getQName().getNamespaceURI())) {
                object = oReply.operation.getFault(replyActivity.getFaultName().getLocalPart());
            }
            if (object == null) {
                throw new CompilationException(__cmsgsLocal.errUndeclaredFault(replyActivity.getFaultName().getLocalPart(), oReply.operation.getName()));
            }
            if (oReply.variable != null && !((OMessageVarType)oReply.variable.type).messageType.equals(object.getMessage().getQName())) {
                throw new CompilationException(_cmsgsGeneral.errVariableTypeMismatch(oReply.variable.name, object.getMessage().getQName(), ((OMessageVarType)oReply.variable.type).messageType));
            }
            oReply.fault = replyActivity.getFaultName();
        } else {
            assert (oReply.fault == null);
            if (oReply.variable == null) {
                throw new CompilationException(__cmsgsLocal.errOutputVariableMustBeSpecified());
            }
            if (!((OMessageVarType)oReply.variable.type).messageType.equals(oReply.operation.getOutput().getMessage().getQName())) {
                throw new CompilationException(_cmsgsGeneral.errVariableTypeMismatch(oReply.variable.name, oReply.operation.getOutput().getMessage().getQName(), ((OMessageVarType)oReply.variable.type).messageType));
            }
        }
        for (Correlation correlation : replyActivity.getCorrelations()) {
            OScope.CorrelationSet correlationSet = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case UNSET: 
                case NO: {
                    oReply.assertCorrelations.add(correlationSet);
                    break;
                }
                case YES: {
                    oReply.initCorrelations.add(correlationSet);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            for (OProcess.OProperty oProperty : correlationSet.properties) {
                this._context.resolvePropertyAlias(oReply.variable, oProperty.name);
            }
        }
    }
}

